/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: libgladeemu.cpp,v 1.3.2.5 2004/11/24 23:00:23 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "libgladeemu.h"
#include "commonapp.h"

#include <string.h>

extern "C"
{
/* Include all the generated source code */
#  include "support.h"
#  include "main_interface.h"
#  include "clipdetails_interface.h"
#  include "preferences_interface.h"
#  include "uri_interface.h"
#  include "about_interface.h"
#  include "contextmenu_interface.h"
#  include "auth_interface.h"
#  include "transport_interface.h"
#  include "plugins_interface.h"
#  include "error_interface.h"
#  include "upgrade_interface.h"
#  include "favorites_interface.h"
#  include "statistics_interface.h"
#  include "unsupportedbrowser_interface.h"
#ifdef HELIX_FEATURE_RP_SIGN_IN
#  include "signin_interface.h"
#endif
#  include "setup_interface.h" /* for the setup assistant */
#ifdef HELIX_FEATURE_HARDWARE_COLOR_CONTROLS 
#  include "vidctrls_interface.h"
#endif
}

/* libglade-compatible stubs 
 * =========================
 * Designed to work with generated gtk code
 */

#ifndef USE_LIBGLADE
#include "support.h"

/* Provide libglade-like stubs for generated code */
void glade_init(void)
{
    gchar* pixmap_dir;
    const gchar* brand_dir;

    brand_dir = APP_NAME_SHORT;
    
    pixmap_dir = g_strdup_printf("%s/%s/default",
                                 g_hxcommon_app.package_data_dir,
                                 g_hxcommon_app.package);    
    add_pixmap_directory(pixmap_dir);
    g_free(pixmap_dir);

    pixmap_dir = g_strdup_printf("%s/%s/%s",
                                 g_hxcommon_app.package_data_dir,
                                 g_hxcommon_app.package,
                                 brand_dir);    
    add_pixmap_directory(pixmap_dir);
    g_free(pixmap_dir);

}

void glade_xml_destroy(GladeXML*)
{
    /* Do nothing */
}

void glade_xml_signal_autoconnect(GladeXML*)
{
    /* Generated code does this automatically */
}

/* Support function for glade_xml_new, displayed if a given
   glade file isn't supported yet */
static void
show_not_implemented_message_box(void)
{
    GtkWidget* dialog;

    dialog = gtk_message_dialog_new(NULL,
                                    GTK_DIALOG_MODAL,
                                    GTK_MESSAGE_ERROR,
                                    GTK_BUTTONS_OK,
                                    _("Not implemented"));

    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

    gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
}

GladeXML *glade_xml_new(const gchar *name, void*, void*)
{
    if(strstr(name, "main.glade"))
    {
        return create_hxplayer_main_window();
    } 
    else if(strstr(name, "clipdetails.glade"))
    {
        return create_hxplayer_clip_details_dialog();
    }
    else if(strstr(name, "preferences.glade"))
    {
        return create_hxplayer_preferences_dialog();
    }
    else if(strstr(name, "uri.glade"))
    {
        return create_hxplayer_open_uri_dialog();
    }
    else if(strstr(name, "about.glade"))
    {
        return create_hxplayer_about_dialog();
    }
    else if(strstr(name, "contextmenu.glade"))
    {
        return create_hxplayer_context_menu();
    }
    else if(strstr(name, "auth.glade"))
    {
        return create_hxplayer_auth_dialog();
    }
    else if(strstr(name, "transport.glade"))
    {
        return create_hxplayer_transport_settings();
    }
    else if(strstr(name, "plugins.glade"))
    {
        return create_hxplayer_plugins_dialog();
    }
    else if(strstr(name, "error.glade"))
    {
        return create_hxplayer_error_dialog();
    }
    else if(strstr(name, "upgrade.glade"))
    {
        return create_hxplayer_upgrade_dialog();
    }
    else if(strstr(name, "favorites.glade"))
    {
        return create_hxplayer_favorites_dialog();
    }
    else if(strstr(name, "statistics.glade"))
    {
        return create_hxplayer_statistics_dialog();
    }
    else if(strstr(name, "unsupportedbrowser.glade"))
    {
        return create_hxplayer_unsupported_browser_warning_dialog();
    }
#ifdef HELIX_FEATURE_RP_SIGN_IN
    else if(strstr(name, "signin.glade"))
    {
        return create_hxplayer_sign_in_dialog();
    }
#endif
    else if(strstr(name, "setup.glade"))
    {
        return create_setup_assistant();
    }
#ifdef HELIX_FEATURE_HARDWARE_COLOR_CONTROLS 
    else if(strstr(name, "vidctrls.glade"))
    {
        return create_hxplayer_video_controls_dialog();
    }
#endif
    
    show_not_implemented_message_box();
    
    return NULL;
}

GtkWidget *glade_xml_get_widget(GladeXML *xml, const gchar *name)
{
    return lookup_widget(xml, name);
}
#else
void glade_xml_destroy(GladeXML *xml)
{
    g_object_unref(G_OBJECT(xml));
}
#endif
