/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: vidosurf.h,v 1.2.34.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _VIDO_SURF_H_
#define _VIDO_SURF_H_


#ifdef _MACINTOSH
#include "hxcolor.h"
#ifdef _MAC_MACHO
#include <QuickTime/QuickTime.h>
#else
#include <ImageCodec.h>	// for overlay support
#endif
#endif

class CHXSimpleList;
class HXScheduler;

class CHXVideoSurface : public CHXSurface
{

protected:

    virtual ~CHXVideoSurface();

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

#ifdef _WINDOWS
    HDC			    m_hDC;
    // section build
    BOOL		    m_bInitialized;
    HDC			    m_hMemoryDC;
    HBITMAP		    m_hOldBitmap;
    HBITMAP		    m_hBmpMem;
    HPALETTE		    m_hOldPal;
    HPALETTE		    m_hPal;
    int			    m_nMemDCWidth;
    int			    m_nMemDCHeight;

    // draw dib
    HDRAWDIB		    m_hDrawDIB;
    // common
    UCHAR*		    m_pDibBits;

#ifdef _WINDOWS
    HFONT		    m_hFont;		// Font to draw the status text with
    HBRUSH		    m_hStatusBrush;	// Brush with status text color
    HPEN		    m_hNullPen;		// Pen for shadow of status text
#endif /* _WIN32 */
#endif	/* _WINDOWS */

    int			    m_nStatusTextHeight;// Height of the status text
    CHXString		    m_StatusText;	// The Status Text

#if defined(_MACINTOSH) || defined(_WINDOWS)
    HX_MOFTAG	GetFormatForDisplay(INT16* pDisplayDepth);
#endif

#ifdef _MACINTOSH
    
    friend class CHXSiteManager;
    friend class CHXSiteWindowed;
    
    enum {
	kEightBitDepth = 0,
	kSixteenBitDepth,
	kThirtyTwoBitDepth,
	kNumberOfDepths
    };
    enum {
	kMaxMonitors = 10
	// make the assumption that they won't have more than 10
	// monitors hooked up(!)
    };
    
    RgnHandle		    m_RgnHandle;
    WindowPtr 		    m_pWnd;
    UCHAR *		    m_pImageData; 
    static PicHandle	    sLogoPict;
    static UINT16	    zm_Logo_PICT_ID;

    static INT32	    DepthToDepthEnum(short depth);
    void		    DrawBackgroundPICT(void);
    void		    SetupClipRegion(void);
    void		    RestoreClipRegion(void);
    BOOL 		    GetBitDepth(INT16 &nDepth);
    
    static UINT32		zm_uNumberOfAttachedDevices;
    static GDHandle		zm_AttachedDevice[kMaxMonitors];
    
    GWorldPtr			m_InterimGWorld[kNumberOfDepths];
    PixMapHandle		m_InterimGWorldPixMap[kNumberOfDepths];
    UINT16			m_uInterimGWorldWidth;
    UINT16			m_uInterimGWorldHeight;
    UINT16			m_uLastBlitWidth;
    UINT16			m_uLastBlitHeight;
    LPHXCOLORCONVERTER	m_pColorConverter[kNumberOfDepths];
    
    void			SetUpColorConverter( HXBitmapInfoHeader* pBitmapInfo, Rect* dstRect );
    void			UpdateColorAdjustments();
    
    // stuff added for interrupt-time blitting... namely, we have to convert the visRgn
    // into a list of rectangles.
    
    CHXSimpleList*	mVisRgnRects;
    RgnHandle		mLastVisRgn;
    void		CheckRectRgn( Rect r, RgnHandle rgn, Point globalOffset );
    void		UpdateRegionIfNecessary( Rect boundingRect, Point globalOffset, BOOL bForceItToUpdate = FALSE );
    
    void		ReflectRectsToScreen( CHXSimpleList* theListOfRectsToBlit, const Rect& trimToThisRect, REF(CHXxRect) rSrcRect );
    static void		MenuRestoreCallback( Rect* theRectToRestore );
    static pascal void		VisRgnChangedCallback(void);
    
    Point		m_LocalToGlobalCoords;
    BOOL		m_bItsOKToDoAnInterruptBlit;
    
    static CHXSimpleList	zm_VideoSurfaceList;
    
    class SystemTimeRequestCallback : public IHXCallback
    {
    private:
	LONG32		m_lRefCount;
			~SystemTimeRequestCallback();
    public:
			SystemTimeRequestCallback();
	
	// IUnknown methods
	STDMETHOD(QueryInterface)	( THIS_ REFIID riid, void**ppvObj );
	STDMETHOD_(ULONG32,AddRef)	( THIS );
	STDMETHOD_(ULONG32,Release)	( THIS );
	
	// IHXCallback methods
	STDMETHOD(Func)			( THIS );
	
	BOOL				m_bPending;
	CallbackHandle			m_ulSystemTimeRequestCallbackPendingID;
    };
    
    SystemTimeRequestCallback*	m_pSystemTimeRequestCallback;
    HXScheduler*		m_pScheduler;
    
    // overlay support on the Mac
    
    static CHXVideoSurface* zm_pSurfaceUsingOverlay; // will be nil if there are none.
    static Ptr zm_pOverlayAddress;
    static LPHXCOLORCONVERTER zm_pOverlayColorConverter;
    static Handle zm_ImageDescription;
    static Ptr zm_pDecompressRecord;
    static ImageSubCodecDecompressRecord zm_DRP;
    static ComponentInstanceRecord* zm_YUV;
    static Rect zm_OverlayRect;
    static BOOL zm_bInitializedOverlay;
    static BOOL zm_bOverlayExists;
    
    int m_nInCID;
    BOOL m_bNaughtDrawn;
    BOOL m_bNeedToPaintOverlayKeyColor;
    
    
    static BOOL SetUpOverlay(Rect globalScreenRect, int bitmapWidth, int bitmapHeight);
    static void CleanUpOverlay();
    BOOL ActualOverlayStuff( Rect globalScreenRect, unsigned char* pImageData,
    		int bitmapWidth, int bitmapHeight, int imagePitch,
    		int srcLeft, int srcTop, int srcWidth, int srcHeight);
public:
    static BOOL OverlayExists();
    
protected:

#endif /* _MACINTOSH */

    STDMETHOD(BltImage)		(UCHAR* pImageData,
				HXBitmapInfoHeader* pBitmapInfo,
				REF(CHXxRect) rDestRect,
				REF(CHXxRect) rSrcRect);


public:

    CHXVideoSurface(IUnknown* pContext, CHXSiteWindowed* pSite);
    STDMETHOD(SetStatusText) (const char* pszText);

#ifdef _MACINTOSH
    HX_RESULT		Init(); 
#endif

#ifdef _WINDOWS
    STDMETHOD		(DrawStatusText)(HDC hdc, REF(CHXxRect)	rDestRect);
    HX_RESULT		Init(HDC hDC); 

    STDMETHOD		(BltImageToDC)(
			   HDC			hDC,
			   UCHAR*		pImageData,
			   HXBitmapInfoHeader*	pBitmapInfo,
			   REF(CHXxRect)	rDestRect,
			   REF(CHXxRect)	rSrcRect);

    void		SetupMemDC(const CHXxRect& rDestRect);

#endif	/* _WINDOWS */

};

#endif	// _VIDO_SURF_H_
