{- Copyright (c) 2007 John Goerzen <jgoerzen@complete.org>
   Please see the COPYRIGHT file -}

import Utils
import HSH
import Control.Monad
import Types
import System.Environment
import System.Directory

{- Merge algorithm here:

If we're merging .hgtags, then we need to combine all the tags together.
Otherwise, we just take the version from the branch being merged in,
which is an upstream version.  This will force the result to match
upstream, which is fine, since we'll import new Debian on top of it.
-}

main = 
  do args <- getArgs
     when (length args /= 3) $ die 1 "Expecting 3 args"
     let newfile = args !! 0 ++ ".new"
     if basename (args !! 0) == ".hgtags"
        then do runIO $ catFrom args -|- "sort -k2" -|- "uniq" -|- catTo newfile
                runIO $ ("grep", ["UPSTREAM", newfile]) -|- catTo (args !! 0)
                runIO $ ("grep", ["-v", "UPSTREAM", newfile]) -|-
                        appendTo (args !! 0)
                removeFile newfile
        else copyFile (args !! 2) (args !! 0)