/*
 * This file is part of hildon-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Lucas Rocha <lucas.rocha@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __HD_PLUGIN_MANAGER_H__
#define __HD_PLUGIN_MANAGER_H__

#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>

#include "hd-ui-policy.h"

G_BEGIN_DECLS

typedef struct _HDPluginManager HDPluginManager;
typedef struct _HDPluginManagerClass HDPluginManagerClass;
typedef struct _HDPluginManagerPrivate HDPluginManagerPrivate;

#define HD_TYPE_PLUGIN_MANAGER            (hd_plugin_manager_get_type ())
#define HD_PLUGIN_MANAGER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HD_TYPE_PLUGIN_MANAGER, HDPluginManager))
#define HD_PLUGIN_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  HD_TYPE_PLUGIN_MANAGER, HDPluginManagerClass))
#define HD_IS_PLUGIN_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HD_TYPE_PLUGIN_MANAGER))
#define HD_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  HD_TYPE_PLUGIN_MANAGER))
#define HD_PLUGIN_MANAGER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  HD_TYPE_PLUGIN_MANAGER, HDPluginManagerClass))

struct _HDPluginManager 
{
  GObject gobject;

  HDPluginManagerPrivate *priv;
};

struct _HDPluginManagerClass 
{
  GObjectClass parent_class;
};

GType      hd_plugin_manager_get_type   (void);

GObject*   hd_plugin_manager_new        (void);

void       hd_plugin_manager_load       (HDPluginManager *pm,
                                         GList           *plugin_list, 
                                         GtkContainer    *container,
					 HDUIPolicy      *policy);

void       hd_plugin_manager_sync       (HDPluginManager *pm,
                                         GList           *plugin_list, 
                                         GtkContainer    *container,
					 HDUIPolicy      *policy,
					 gboolean         keep_order);

G_END_DECLS

#endif /* __HD_PLUGIN_MANAGER_H__ */
