///////
   //    _Server.cc
   //    _Server Class definitions
   //
   //    Class to interface with Server table of mysql Database
   //    This inherits from the Server class.
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Server.cc,v 1.9 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 02.07.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "_Server.h"

///////
   //    Static variables
///////

   unsigned int _Server::TotServers = 0;
   

///////
   //    Construction
///////

_Server::_Server (const String &host, int port )
   : Server (host, port),
    IDServer(0),
    IPAddress(0),
    HttpServer(0),
    HttpVersion(0),
    Requests(0)
{
}


_Server::_Server (const _Server& rhs)
   : Server (rhs),
    IDServer(rhs.IDServer),
    IPAddress(rhs.IPAddress),
    HttpServer(rhs.HttpServer),
    HttpVersion(rhs.HttpVersion),
    Requests(rhs.Requests)
{
}


///////
   //    Destruction
///////

_Server::~_Server ()
{
   
}
