/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _XIMPInputContext_hh
#define _XIMPInputContext_hh

#include "XIMProto.hh"
#include "InputContext.hh"
#include "CompoundString.hh"

class XIMProtocol;

// for preedit start callback
typedef int (*XIMProc1)(XIC, XPointer, XPointer);
typedef struct {
  XPointer client_data;
  XIMProc1 callback;
} XIMCallback1;

// for any other else
typedef void (*XIMProc2)(XIC, XPointer, XPointer);
typedef struct {
  XPointer client_data;
  XIMProc2 callback;
} XIMCallback2;

class XIMPInputContext : public InputContext {
 public:
  XIMPInputContext(XIMProtocol *ximp, XClientMessageEvent *ev);
  ~XIMPInputContext();

// XIM callbacks
  static int preedit_start_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void preedit_draw_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void preedit_caret_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);
  static void preedit_done_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void status_start_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void status_draw_cbproc(XIC xic, XPointer client_data,
				 XPointer call_data_p);
  static void status_done_cbproc(XIC xic, XPointer client_data,
				 XPointer call_data_p);
  static void state_notify_cbproc(XIC xic, XPointer client_data,
				  XPointer call_data_p);
  static void commit_string_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);
  static void forward_event_cbproc(XIC xic, XPointer client_data,
				   XPointer call_data_p);

  const CompoundString& getUser() const;
  const CompoundString& getLocaleName() const;
  const CompoundString& getEngineName() const;

  // CLIENT DESCRIPTOR
  const CompoundString& getApplicationName() const;
  const CompoundString& getOSName() const;
  const CompoundString& getOSArch() const;
  const CompoundString& getOSVersion() const;
  // Client Display Info
  const CompoundString& getXDisplayString() const;
  const CompoundString& getXServerVendor() const;

  int commit_string(IMText *text);
  int forward_event(IMKeyEventStruct *event);
  int preedit_start(IMPreeditStruct *preedit);
  int preedit_draw(IMPreeditStruct *preedit);
  int preedit_caret(IMPreeditStruct *preedit);
  int preedit_done(IMPreeditStruct *preedit);
  int status_start(IMStatusStruct *status);
  int status_draw(IMStatusStruct *status);
  int status_done(IMStatusStruct *status);
  int lookup_start(IMLookupStruct *lookup);
  int lookup_draw(IMLookupStruct *lookup);
  int lookup_process(IMLookupStruct *lookup);
  int lookup_done(IMLookupStruct *lookup);
  int auxiliary_start(IMAuxStruct *auxiliary);
  int auxiliary_draw(IMAuxStruct *auxiliary);
  int auxiliary_done(IMAuxStruct *auxiliary);
  int conversion_start();
  int conversion_end();

  int conversion_start(Bool reply_back);
  int conversion_end(Bool reply_back);

  Window focus_window();
  Window client_window();

  int focus_window(Window&) const;
  int client_window(Window&) const;

  Bool is_version_40() {return (proto_version == XIMP_VERSION_40);}
  Bool is_conv_state() {return is_conv_on;}
  Bool set_conv_state(Bool flag) {return is_conv_on = flag;}
  Bool is_ximp_type(long type) {return (ev_flow_type == type);}
  Bool is_sync();

  void set_client_window(Window new_win);
  void set_focus_window(Window new_win);
  void set_fwin_select_mask(long mask);
  void set_preedit_spot_location(long x, long y);
  void set_preedit_maxlen(unsigned long len);
  void set_preedit_caret_position(unsigned long pos);

  void set_preedit_area(long x, long y, unsigned long width,
			unsigned long height);
  void set_preedit_area_needed(unsigned long width, unsigned long height);
  void set_preedit_colormap(Colormap colormap);
  void set_preedit_fg(unsigned long);
  void set_preedit_bg(unsigned long);
  void set_preedit_bg_pixmap(Pixmap pixmap);
  void set_preedit_line_spacing(long);
  void set_preedit_cursor(Cursor cursor);

  void set_status_area(long x, long y, unsigned long width,
		       unsigned long height);
  void set_status_area_needed(unsigned long width, unsigned long height);
  void set_status_colormap(Colormap colormap);
  void set_status_fg(unsigned long);
  void set_status_bg(unsigned long);
  void set_status_bg_pixmap(Pixmap pixmap);
  void set_status_line_spacing(long);
  void set_status_cursor(Cursor cursor);

  void set_values(XClientMessageEvent *ev);
  void get_values(XClientMessageEvent *ev);

  void select_destroy_emask();
  void select_destroy_clientwin_emask();
  void select_keypress_emask();
  void select_keyrelease_emask();
  void unselect_destroy_emask();
  void unselect_destroy_clientwin_emask();
  void unselect_keypress_emask();
  void unselect_keyrelease_emask();

  void set_match(int kcode, int state);
  Bool process_match(int kcode, int state);

  XIMProtocol *ximp_protocol;

  char *get_commit_string();

  char *reset_xic();
  void destroy_xic();
  void set_xicfocus();
  void unset_xicfocus();

  Bool checkAltKey(XClientMessageEvent *ev);
  
  // backward compativility
  int forward_xevent(XEvent *event);

 private:
  static Bool destroy_clientwin_filter(Display *, Window, XEvent*, XPointer);
  void register_clientwin_destroy_filter();
  void unregister_clientwin_destroy_filter();

  XIC xic;
  Display *dpy;
  // XICCore part
  XIMStyle inputstyle;		/* IM's input style */
  Window client_win;		/* window IM can use for */
  Window focus_win;		/* where key events go */
  Ximp_PreeditPropRec4	preedit_attr4;
  char			*preedit_fontname;
  Ximp_StatusPropRec4	status_attr4;
  char			*status_fontname;

  // XICXimp part
  long attr_mask;
  long ev_flow_type;	// event flow type
  long ev_masks;	// holds client's interest masks
  long filters;
  Bool is_conv_on;	/* holds current conversion state */
  int og_code;		/* holds keycode to keep matching */
  int og_state;		/* holds keystate to keep matching */
  Bool being_reset;	// whether XIC is being reset or not
  CompoundString reset_text;

  XIMCallback1 *preedit_start_cb;

  XIMCallback2 *preedit_draw_cb;
  XIMCallback2 *preedit_caret_cb;
  XIMCallback2 *preedit_done_cb;
  XIMCallback2 *status_start_cb;
  XIMCallback2 *status_draw_cb;
  XIMCallback2 *status_done_cb;

  XIMCallback2 *state_notify_cb;
  XIMCallback2 *commit_string_cb;
  XIMCallback2 *forward_event_cb;

  CompoundString user_name;

  CompoundString application_name;
  CompoundString os_name;
  CompoundString os_arch;
  CompoundString os_version;

  CompoundString xDisplayName;
  CompoundString xServerVendor;

  unsigned long preedit_maxlen;
  unsigned long preedit_caret_position;

  enum XimpProtocolVersion {
    XIMP_VERSION_35, XIMP_VERSION_40, XIMP_VERSION_UNKNOWN
  };

  enum XimpFilterMode {
    FLT_NONE = (0L), FLT_KEYPRESS = (1L<<0),
    FLT_KEYRELEASE = (1L<<1), FLT_DESTROY = (1L<<2)
  };

  enum Ximp40ICMask {
    XIMP_FOCUS_WIN_MASK4	= (1L <<  0),
    XIMP_PRE_AREA_MASK4		= (1L <<  1),
    XIMP_PRE_AREANEED_MASK4	= (1L <<  2),
    XIMP_PRE_COLORMAP_MASK4	= (1L <<  3),
    XIMP_PRE_STD_COLORMAP_MASK4 = (1L <<  4),
    XIMP_PRE_FG_MASK4		= (1L <<  5),
    XIMP_PRE_BG_MASK4		= (1L <<  6),
    XIMP_PRE_BGPIXMAP_MASK4	= (1L <<  7),
    XIMP_PRE_LINESP_MASK4	= (1L <<  8),
    XIMP_PRE_CURSOR_MASK4	= (1L <<  9),
    XIMP_PRE_SPOTL_MASK4	= (1L << 10),
    XIMP_STS_AREA_MASK4		= (1L << 11),
    XIMP_STS_AREANEED_MASK4	= (1L << 12),
    XIMP_STS_COLORMAP_MASK4	= (1L << 13),
    XIMP_STS_STD_COLORMAP_MASK4	= (1L << 14),
    XIMP_STS_FG_MASK4		= (1L << 15),
    XIMP_STS_BG_MASK4		= (1L << 16),
    XIMP_STS_BGPIXMAP_MASK4	= (1L << 17),
    XIMP_STS_LINESP_MASK4	= (1L << 18),
    XIMP_STS_CURSOR_MASK4	= (1L << 19),
    XIMP_STS_WINDOW_MASK4	= (1L << 20),
    XIMP_PRE_FONT_MASK4		= (1L << 21),
    XIMP_STS_FONT_MASK4		= (1L << 22),
    XIMP_SERVERTYPE_MASK4	= (1L << 23)
  };

  enum Ximp35ICMask {
    XIMP_FOCUS_WIN_MASK3	= (1L <<  0),
    XIMP_PRE_AREA_MASK3		= (1L <<  1),
    XIMP_PRE_FG_MASK3		= (1L <<  2),
    XIMP_PRE_BG_MASK3		= (1L <<  3),
    XIMP_PRE_COLORMAP_MASK3	= (1L <<  4),
    XIMP_PRE_BGPIXMAP_MASK3	= (1L <<  5),
    XIMP_PRE_LINESP_MASK3	= (1L <<  6),
    XIMP_PRE_CURSOR_MASK3	= (1L <<  7),
    XIMP_PRE_AREANEED_MASK3	= (1L <<  8),
    XIMP_PRE_SPOTL_MASK3	= (1L <<  9),
    XIMP_STS_AREA_MASK3		= (1L << 10),
    XIMP_STS_FG_MASK3		= (1L << 11),
    XIMP_STS_BG_MASK3		= (1L << 12),
    XIMP_STS_COLORMAP_MASK3	= (1L << 13),
    XIMP_STS_BGPIXMAP_MASK3	= (1L << 14),
    XIMP_STS_LINESP_MASK3	= (1L << 15),
    XIMP_STS_CURSOR_MASK3	= (1L << 16),
    XIMP_STS_AREANEED_MASK3	= (1L << 17),
    XIMP_STS_WINDOW_MASK3	= (1L << 18),
    XIMP_PRE_FONT_MASK3		= (1L << 19),
    XIMP_STS_FONT_MASK3		= (1L << 20)
  };

  XimpProtocolVersion proto_version;

  enum XIC_MASK {
    PREEDIT_MASK4 = (XIMP_PRE_AREA_MASK4|XIMP_PRE_AREANEED_MASK4|
		     XIMP_PRE_COLORMAP_MASK4|XIMP_PRE_STD_COLORMAP_MASK4|
		     XIMP_PRE_FG_MASK4|XIMP_PRE_BG_MASK4|
		     XIMP_PRE_BGPIXMAP_MASK4|XIMP_PRE_LINESP_MASK4|
		     XIMP_PRE_CURSOR_MASK4|XIMP_PRE_SPOTL_MASK4),
    STATUS_MASK4 = (XIMP_STS_AREA_MASK4|XIMP_STS_AREANEED_MASK4|
		    XIMP_STS_COLORMAP_MASK4|XIMP_STS_STD_COLORMAP_MASK4|
		    XIMP_STS_FG_MASK4|XIMP_STS_BG_MASK4|
		    XIMP_STS_BGPIXMAP_MASK4|XIMP_STS_LINESP_MASK4|
		    XIMP_STS_CURSOR_MASK4|XIMP_STS_WINDOW_MASK4),
    PREEDIT_MASK3 = (XIMP_PRE_AREA_MASK3|XIMP_PRE_AREANEED_MASK3|
		     XIMP_PRE_COLORMAP_MASK3|XIMP_PRE_FG_MASK3|
		     XIMP_PRE_BG_MASK3|XIMP_PRE_BGPIXMAP_MASK3|
		     XIMP_PRE_LINESP_MASK3|XIMP_PRE_CURSOR_MASK3|
		     XIMP_PRE_SPOTL_MASK3),
    STATUS_MASK3 = (XIMP_STS_AREA_MASK3|XIMP_STS_AREANEED_MASK3|
		    XIMP_STS_COLORMAP_MASK3|XIMP_STS_FG_MASK3|
		    XIMP_STS_BG_MASK3|XIMP_STS_BGPIXMAP_MASK3|
		    XIMP_STS_LINESP_MASK3|XIMP_STS_CURSOR_MASK3|
		    XIMP_STS_WINDOW_MASK3)
  };

  enum XimpClientMessageSize {
    COMMIT_CMSG_MAX = 30
  };

  enum XimpPDCBStates {
    XIMP_PDCBSTATUS_NOTEXT = 0x0001,
    XIMP_PDCBSTATUS_NOFEEDBACK = 0x0002,
    XIMP_PDCBSTATUS_FEEDBACKS_VIA_PROP = 0x0004
  };

  Bool get_xicvalues(unsigned long&);
  Bool get_focus_win();
  Bool get_preedit_font();
  Bool get_status_font();
  Bool get_preedit4(unsigned long);
  Bool get_status4(unsigned long);
  Bool get_server_type4();
  Bool get_preedit3(unsigned long);
  Bool get_status3(unsigned long);

  Bool set_xicvalues(unsigned long&);
  Bool set_focus_win();
  Bool set_preedit_font();
  Bool set_status_font();
  Bool set_preedit4();
  Bool set_status4();
  Bool set_server_type4();
  Bool set_preedit3();
  Bool set_status3();

  // backward compativility
  int commit_string(char *text);
  int preedit_draw(XIMPreeditDrawCallbackStruct *draw);
  int preedit_caret(XIMPreeditCaretCallbackStruct *caret);
  int status_draw(XIMStatusDrawCallbackStruct *draw);
  // int lookup_draw(XIMLookupDrawCallbackStruct *draw);

  int preedit_draw_by_cm(XIMPreeditDrawCallbackStruct *draw);

  int preedit_draw_feedback(XIMPreeditDrawCallbackStruct *draw);
  int preedit_draw_tiny(XIMPreeditDrawCallbackStruct *draw);

  // for delay binding to IIIMP server
  void DelayBind();
  void CreateXIC();
  void SetExtensionCallbacks();
  void SetPreeditCallbacks();
  void SetStatusCallbacks();
};

#endif
