/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifndef _KOLE_AUX_MESSAGE_H_
#define _KOLE_AUX_MESSAGE_H_

#define XAUX_OBJECT_CLASS_NAME          "com.sun.iiim.kole.aux.object"

enum AUXWIN_PROTOCOL {
  PALETTEAUX_CONNECT = 	1,
  PALETTEAUX_SWITCH_INPUT_MODE = 2,
  PALETTEAUX_SWITCH_IME = 3,
  PALETTEAUX_SWITCH_QJBJ = 4,
  PALETTEAUX_HANJA_CONVERSION = 5,
  PALETTEAUX_CHANGE_POSITION = 6,
  PALETTEAUX_SHOW_OPTIONAUX = 7,
  PALETTEAUX_SHOW_SELECTAUX = 8,
  PALETTEAUX_SHOW_KEYBOARDAUX = 9,
  PALETTEAUX_SHOW_LOOKUPAUX = 10,
  PALETTEAUX_START_ACTION = 11,
  /*  PALETTEAUX_SET_LOCALE			12 */

  PALETTEAUX_SWITCH_INPUT_MODE_NOTIFY = 13,
  PALETTEAUX_SWITCH_CONVERSION_NOTIFY = 14,
  PALETTEAUX_SWITCH_QJBJ_NOTIFY = 15,
  PALETTEAUX_SWITCH_PUNCT_NOTIFY = 16,
  PALETTEAUX_SWITCH_CHARSET_NOTIFY = 17,
  

  /* For Common used protocol */
  COMMONAUX_COMMIT_KEY = 20,
  COMMONAUX_COMMIT_STRING = 21,
  COMMONAUX_UPDATE_OPTIONSINFO = 22,
  COMMONAUX_LOST_FOCUS = 23,

  COMMONAUX_CHANGE_FOCUS_NOTIFY = 24,
  COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY = 25,
  COMMONAUX_SET_IME_NEW_NOTIFY = 26,
  COMMONAUX_SET_IME_INFO_NOTIFY = 27,
  COMMONAUX_SET_IME_END_NOTIFY = 28,

  /* For OptionAux */
  OPTIONAUX_CONNECT = 30,
  OPTIONAUX_CHANGE_STATUS = 31,

  OPTIONAUX_SHOW_NOTIFY = 32,
  OPTIONAUX_HIDE_NOTIFY = 33,
  OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY = 34,
  OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY = 35,

  /* For SelectAux */
  SELECTAUX_CONNECT = 40,
  SELECTAUX_UPDATE_IMEINFO = 41,
  SELECTAUX_CHANGE_STATUS = 42,

  SELECTAUX_SHOW_NOTIFY = 43,
  SELECTAUX_HIDE_NOTIFY = 44,

  /* For KeyboardAux */
  KEYBOARDAUX_CONNECT = 50,
  KEYBOARDAUX_CHANGE_POSITION = 51,
  KEYBOARDAUX_CHANGE_KEY_STATUS = 52,

  KEYBOARDAUX_SHOW_NOTIFY = 53,
  KEYBOARDAUX_HIDE_NOTIFY = 54,
  KEYBOARDAUX_PRESS_KEY_NOTIFY = 55,

  /* For LookupAux */
  LOOKUPAUX_CONNECT = 60,
  LOOKUPAUX_CHANGE_STATUS = 61,
  LOOKUPAUX_CHANGE_POSITION = 62,

  LOOKUPAUX_SHOW_NOTIFY = 63,
  LOOKUPAUX_HIDE_NOTIFY = 64,

  /* For ActionAux */
  ACTIONAUX_CONNECT = 70,
  ACTIONAUX_START_ACTION_NOTIFY = 71,

  /* For 3beol-sik keybord layout support */
  PALETTEAUX_SWITCH_KEYBOARDLAYOUT = 80,
  KOLE_AUX_SESSION_PROPERTY = 100
};

#endif
