/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "le.h"
#include "encode.h"
#include "iml.h"
#include "logf.h"
#include "encode_draw.h"

void ime_buffer_free(IMEBuffer ime_buffer);

/* ============================================================== */
/*                   IME buffer for every session                 */
/* ============================================================== */
IMEBufferRec *ime_buffer_malloc()
{
    int i;
    IMEBuffer ime_buffer;

    ime_buffer = (IMEBufferRec *)calloc(1, sizeof(IMEBufferRec));

    ime_buffer->inputkey_buf = (int *)calloc(MAX_INPUT_KEY_NUM, sizeof(int));	
    ime_buffer->preedit_buf = (unsigned char *)calloc(MAX_PREEDIT_CHAR_NUM, sizeof(char));
    ime_buffer->prev_preedit_buf = (unsigned char *)calloc(MAX_PREEDIT_CHAR_NUM, sizeof(char));
    ime_buffer->status_buf = (unsigned char *)calloc(MAX_STATUS_CHAR_NUM, sizeof(char));
    ime_buffer->commit_buf = (unsigned char *)calloc(MAX_COMMIT_CHAR_NUM, sizeof(char));

    ime_buffer->lookup_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));
    ime_buffer->candidates_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));
    ime_buffer->additions_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));

    if (   	(ime_buffer == NULL) ||
		(ime_buffer->inputkey_buf == NULL) ||
		(ime_buffer->preedit_buf == NULL) ||
		(ime_buffer->prev_preedit_buf == NULL) ||
		(ime_buffer->status_buf == NULL) ||
		(ime_buffer->commit_buf == NULL) ||
		(ime_buffer->lookup_buf == NULL) ||
		(ime_buffer->candidates_buf == NULL) ||
		(ime_buffer->additions_buf == NULL) )
	goto Error;

    for (i =0; i<MAX_CANDIDATES_NUM; i++) {
	ime_buffer->lookup_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));
	ime_buffer->candidates_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));
	ime_buffer->additions_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));

	if ( 	(ime_buffer->lookup_buf[i] == NULL) ||
		(ime_buffer->candidates_buf[i] == NULL) ||
		(ime_buffer->additions_buf[i] == NULL) )
	    goto Error;
    }

    return(ime_buffer);

Error:
    ime_buffer_free(ime_buffer);
    return(NULL);
}

void ime_buffer_free(IMEBuffer ime_buffer)
{
    int i;

    if (ime_buffer->inputkey_buf) free(ime_buffer->inputkey_buf);
    if (ime_buffer->preedit_buf)  free(ime_buffer->preedit_buf);
    if (ime_buffer->prev_preedit_buf)  free(ime_buffer->prev_preedit_buf);
    if (ime_buffer->status_buf)   free(ime_buffer->status_buf);
    if (ime_buffer->commit_buf)   free(ime_buffer->commit_buf);

    for (i =0; i<MAX_CANDIDATES_NUM; i++) {
	if (ime_buffer->lookup_buf[i])
	    free(ime_buffer->lookup_buf[i]);
	if (ime_buffer->candidates_buf[i])
	    free(ime_buffer->candidates_buf[i]);
	if (ime_buffer->additions_buf[i])
	    free(ime_buffer->additions_buf[i]);
    }
	
    if (ime_buffer->lookup_buf)
	free(ime_buffer->lookup_buf);
    if (ime_buffer->candidates_buf)
	free(ime_buffer->candidates_buf);
    if (ime_buffer->additions_buf)
	free(ime_buffer->additions_buf);

    free(ime_buffer);
}

/* ============================================================== */
/*           Change Language Engine Status Information            */
/* ============================================================== */
/* clear input method buffer */
void le_clear_ime_buffer(iml_session_t *s, IMEBuffer ime_buffer)
{
    ime_buffer->lookup_num = 0;
    iml_lookup_enddraw(s);

    ime_buffer->inputkey_len = 0;
    ime_buffer->preedit_len = 0;
    ime_buffer->hotkey_flag = IME_HOTKEY_NOT_IN_USE;
    ime_buffer->conv_flag = -1;
    iml_preedit_enddraw(s);
}

void le_commit_euro(iml_session_t *s, IMEBuffer ime_buffer)
{
    int encode = ime_buffer->encode;
    int status = ime_buffer->return_status;
    int commit_len = ime_buffer->commit_len;
    unsigned char *commit_buf  = ime_buffer->commit_buf;

    if ((status & IME_COMMIT) && (commit_len>0)) {
	commit_buf[commit_len] = 0;
	log_f("commit_buf:%s\n", commit_buf);
	encode_commit(s, encode, commit_buf, commit_len);
    }
}

/* output input method buffer to system */
void le_output_ime_buffer(iml_session_t *s, IMEBuffer ime_buffer)
{

    int encode = ime_buffer->encode;
    int status = ime_buffer->return_status;
    int preedit_len = ime_buffer->preedit_len;
    int commit_len = ime_buffer->commit_len;
    int lookup_num = ime_buffer->lookup_num;
    int lookup_label_type = ime_buffer->lookup_label_type;
    int preedit_caretpos = ime_buffer->preedit_caretpos;
    unsigned char *preedit_buf = ime_buffer->preedit_buf;
    unsigned char *commit_buf  = ime_buffer->commit_buf;
    unsigned char *status_buf  = ime_buffer->status_buf;
    unsigned char **lookup_buf = ime_buffer->lookup_buf;

    if (status & IME_STATUS_AREA)
	encode_draw_status(s, encode, status_buf);

    if (status & IME_PREEDIT_AREA) {
	preedit_buf[preedit_len] = 0;
	if (preedit_len <= 0)
	    iml_preedit_enddraw(s);
	else
	    encode_draw_preedit(s, encode, preedit_buf, preedit_caretpos);
    }


    if (status & IME_LOOKUP_AREA) {
	log_f("lookup_num:%d\n", lookup_num);
	if (lookup_num <= 0)
	    iml_lookup_enddraw(s);
	else
	    encode_draw_candidates(s, encode, lookup_buf, lookup_num, lookup_label_type);
    }

    if ((status & IME_COMMIT) && (commit_len>0)) {
	commit_buf[commit_len] = 0;
	log_f("commit_buf:%s\n", commit_buf);
	encode_commit(s, encode, commit_buf, commit_len);
    }
}

void le_status_draw(unit_desktop_t *udp, iml_session_t *s)
{
    unsigned char status_str[256];
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    int engine_id = session_data->paletteaux_status.engine_id;
    int on = session_data->paletteaux_status.on;

    memset((char *)&status_str, '\0', sizeof(status_str));

    if (!on || engine_id == 0xff){
	log_f("encode_draw_status: ENGLISH \n");
	encode_draw_status(s, ENCODE_UTF8, "");
    } else {
	if (!strcmp(udp->modeList[engine_id]->nlocale_name ,(char *)"ASCII"))
	    sprintf((char *)status_str, "%s", udp->modeList[engine_id]->nlayout_name);
	else if (!strcmp(udp->modeList[engine_id]->nlayout_name, (char *)"ASCII"))
	    sprintf((char *)status_str, "%s", udp->modeList[engine_id]->nlocale_name);
	else
	    sprintf((char *)status_str, "%s", udp->modeList[engine_id]->nlayout_name);
	log_f("encode_draw_status: [%s] \n",status_str);
	encode_draw_status(s, udp->gEngine_Info[engine_id]->core.baseinfo.encode_id, status_str);
    }
}

void le_switch_engine(unit_desktop_t *udp, iml_session_t *s, int engine_id, Bool flag)
{
    int ret;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

    if (engine_id >= udp->gEngine_Num)  
	engine_id = 0xff;

    if (engine_id != 0xff && udp->gEngine_Info[engine_id]->core.baseinfo.status == ENGINE_NOT_INSTALLED)
	engine_id = 0xff;

    if (engine_id != 0xff) {
	ret = udp->gEngine_Info[engine_id]->so_methods->IME_Open(
	    &udp->gEngine_Info[engine_id]->core,
	    session_data->ime_buffer,
	    udp->gEngine_Info[engine_id]->so_handler);
		
	log_f("IME_Open return :%d\n", ret);
	if (ret == -1)
	    engine_id = 0xff;
    }

    session_data->paletteaux_status.engine_id = engine_id;
    if (flag)
      le_status_draw(udp, s);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
