#include <qdatetime.h>
#include "IIIMQKeyEvent.hh"

static int
q2icode(
    QKeyEvent *e
)
{
    int qc = e->key();

    switch (qc) {
      case Qt::Key_Escape:
       return IIIMF_KEYCODE_ESCAPE;
      case Qt::Key_Tab:
       return IIIMF_KEYCODE_TAB;
      case Qt::Key_Backtab:
       return 0;
      case Qt::Key_Backspace:
       return IIIMF_KEYCODE_BACK_SPACE;
      case Qt::Key_Return:
       return IIIMF_KEYCODE_ENTER;
      case Qt::Key_Enter:
       return IIIMF_KEYCODE_ENTER;
      case Qt::Key_Insert:
       return IIIMF_KEYCODE_INSERT;
      case Qt::Key_Delete:
       return IIIMF_KEYCODE_DELETE;
      case Qt::Key_Pause:
       return IIIMF_KEYCODE_PAUSE;
      case Qt::Key_Print:
       return -IIIMF_KEYCODE_PRINTSCREEN;
      case Qt::Key_SysReq:
       return 0;
      case Qt::Key_Home:
       return -IIIMF_KEYCODE_HOME;
      case Qt::Key_End:
       return -IIIMF_KEYCODE_END;
      case Qt::Key_Left:
       return -IIIMF_KEYCODE_LEFT;
      case Qt::Key_Up:
       return -IIIMF_KEYCODE_UP;
      case Qt::Key_Right:
       return -IIIMF_KEYCODE_RIGHT;
      case Qt::Key_Down:
       return -IIIMF_KEYCODE_DOWN;
      case Qt::Key_Prior:
       return -IIIMF_KEYCODE_PAGE_UP;
      case Qt::Key_Next:
       return -IIIMF_KEYCODE_PAGE_DOWN;
      case Qt::Key_Shift:
       return -IIIMF_KEYCODE_SHIFT;
      case Qt::Key_Control:
       return -IIIMF_KEYCODE_CONTROL;
      case Qt::Key_Meta:
       return -IIIMF_KEYCODE_META;
      case Qt::Key_Alt:
       return -IIIMF_KEYCODE_ALT;
      case Qt::Key_CapsLock:
       return -IIIMF_KEYCODE_CAPS_LOCK;
      case Qt::Key_NumLock:
       return -IIIMF_KEYCODE_NUM_LOCK;
      case Qt::Key_ScrollLock:
       return -IIIMF_KEYCODE_SCROLL_LOCK;
      case Qt::Key_Clear:
       return -IIIMF_KEYCODE_CLEAR;
      case Qt::Key_F1:
       return -IIIMF_KEYCODE_F1;
      case Qt::Key_F2:
       return -IIIMF_KEYCODE_F2;
      case Qt::Key_F3:
       return -IIIMF_KEYCODE_F3;
      case Qt::Key_F4:
       return -IIIMF_KEYCODE_F4;
      case Qt::Key_F5:
       return -IIIMF_KEYCODE_F5;
      case Qt::Key_F6:
       return -IIIMF_KEYCODE_F6;
      case Qt::Key_F7:
       return -IIIMF_KEYCODE_F7;
      case Qt::Key_F8:
       return -IIIMF_KEYCODE_F8;
      case Qt::Key_F9:
       return -IIIMF_KEYCODE_F9;
      case Qt::Key_F10:
       return -IIIMF_KEYCODE_F10;
      case Qt::Key_F11:
       return -IIIMF_KEYCODE_F11;
      case Qt::Key_F12:
       return -IIIMF_KEYCODE_F12;
      case Qt::Key_F13:
       return -IIIMF_KEYCODE_F13;
      case Qt::Key_F14:
       return -IIIMF_KEYCODE_F14;
      case Qt::Key_F15:
       return -IIIMF_KEYCODE_F15;
      case Qt::Key_F16:
       return -IIIMF_KEYCODE_F16;
      case Qt::Key_F17:
       return -IIIMF_KEYCODE_F17;
      case Qt::Key_F18:
       return -IIIMF_KEYCODE_F18;
      case Qt::Key_F19:
       return -IIIMF_KEYCODE_F19;
      case Qt::Key_F20:
       return -IIIMF_KEYCODE_F20;
      case Qt::Key_F21:
       return -IIIMF_KEYCODE_F21;
      case Qt::Key_F22:
       return -IIIMF_KEYCODE_F22;
      case Qt::Key_F23:
       return -IIIMF_KEYCODE_F23;
      case Qt::Key_F24:
       return -IIIMF_KEYCODE_F24;

      case Qt::Key_F25:
      case Qt::Key_F26:
      case Qt::Key_F27:
      case Qt::Key_F28:
      case Qt::Key_F29:
      case Qt::Key_F30:
      case Qt::Key_F31:
      case Qt::Key_F32:
      case Qt::Key_F33:
      case Qt::Key_F34:
      case Qt::Key_F35:
       return 0;

      case Qt::Key_Super_L:
      case Qt::Key_Super_R:
      case Qt::Key_Menu:
      case Qt::Key_Hyper_L:
      case Qt::Key_Hyper_R:
       return 0;
      case Qt::Key_Help:
       return -IIIMF_KEYCODE_HELP;

      case Qt::Key_Space:
       // case Qt::Key_Any:
       return IIIMF_KEYCODE_SPACE;

      case Qt::Key_Exclam:
      case Qt::Key_QuoteDbl:
      case Qt::Key_NumberSign:
      case Qt::Key_Dollar:
      case Qt::Key_Percent:
      case Qt::Key_Ampersand:
      case Qt::Key_Apostrophe:
      case Qt::Key_ParenLeft:
      case Qt::Key_ParenRight:
      case Qt::Key_Asterisk:
      case Qt::Key_Plus:
      case Qt::Key_Comma:
      case Qt::Key_Minus:
      case Qt::Key_Period:
      case Qt::Key_Slash:
      case Qt::Key_0:
      case Qt::Key_1:
      case Qt::Key_2:
      case Qt::Key_3:
      case Qt::Key_4:
      case Qt::Key_5:
      case Qt::Key_6:
      case Qt::Key_7:
      case Qt::Key_8:
      case Qt::Key_9:
      case Qt::Key_Colon:
      case Qt::Key_Semicolon:
      case Qt::Key_Less:
      case Qt::Key_Equal:
      case Qt::Key_Greater:
      case Qt::Key_Question:
      case Qt::Key_At:
      case Qt::Key_A:
      case Qt::Key_B:
      case Qt::Key_C:
      case Qt::Key_D:
      case Qt::Key_E:
      case Qt::Key_F:
      case Qt::Key_G:
      case Qt::Key_H:
      case Qt::Key_I:
      case Qt::Key_J:
      case Qt::Key_K:
      case Qt::Key_L:
      case Qt::Key_M:
      case Qt::Key_N:
      case Qt::Key_O:
      case Qt::Key_P:
      case Qt::Key_Q:
      case Qt::Key_R:
      case Qt::Key_S:
      case Qt::Key_T:
      case Qt::Key_U:
      case Qt::Key_V:
      case Qt::Key_W:
      case Qt::Key_X:
      case Qt::Key_Y:
      case Qt::Key_Z:
      case Qt::Key_BracketLeft:
      case Qt::Key_Backslash:
      case Qt::Key_BracketRight:
      case Qt::Key_AsciiCircum:
      case Qt::Key_Underscore:
      case Qt::Key_QuoteLeft:
      case Qt::Key_BraceLeft:
      case Qt::Key_Bar:
      case Qt::Key_BraceRight:
      case Qt::Key_AsciiTilde:
       return qc;

      case Qt::Key_nobreakspace:
      case Qt::Key_exclamdown:
      case Qt::Key_cent:
      case Qt::Key_sterling:
      case Qt::Key_currency:
      case Qt::Key_yen:
      case Qt::Key_brokenbar:
      case Qt::Key_section:
      case Qt::Key_diaeresis:
      case Qt::Key_copyright:
      case Qt::Key_ordfeminine:
      case Qt::Key_guillemotleft:
      case Qt::Key_notsign:
      case Qt::Key_hyphen:
      case Qt::Key_registered:
      case Qt::Key_macron:
      case Qt::Key_degree:
      case Qt::Key_plusminus:
      case Qt::Key_twosuperior:
      case Qt::Key_threesuperior:
      case Qt::Key_acute:
      case Qt::Key_mu:
      case Qt::Key_paragraph:
      case Qt::Key_periodcentered:
      case Qt::Key_cedilla:
      case Qt::Key_onesuperior:
      case Qt::Key_masculine:
      case Qt::Key_guillemotright:
      case Qt::Key_onequarter:
      case Qt::Key_onehalf:
      case Qt::Key_threequarters:
      case Qt::Key_questiondown:
      case Qt::Key_Agrave:
      case Qt::Key_Aacute:
      case Qt::Key_Acircumflex:
      case Qt::Key_Atilde:
      case Qt::Key_Adiaeresis:
      case Qt::Key_Aring:
      case Qt::Key_AE:
      case Qt::Key_Ccedilla:
      case Qt::Key_Egrave:
      case Qt::Key_Eacute:
      case Qt::Key_Ecircumflex:
      case Qt::Key_Ediaeresis:
      case Qt::Key_Igrave:
      case Qt::Key_Iacute:
      case Qt::Key_Icircumflex:
      case Qt::Key_Idiaeresis:
      case Qt::Key_ETH:
      case Qt::Key_Ntilde:
      case Qt::Key_Ograve:
      case Qt::Key_Oacute:
      case Qt::Key_Ocircumflex:
      case Qt::Key_Otilde:
      case Qt::Key_Odiaeresis:
      case Qt::Key_multiply:
      case Qt::Key_Ooblique:
      case Qt::Key_Ugrave:
      case Qt::Key_Uacute:
      case Qt::Key_Ucircumflex:
      case Qt::Key_Udiaeresis:
      case Qt::Key_Yacute:
      case Qt::Key_THORN:
      case Qt::Key_ssharp:
      case Qt::Key_agrave:
      case Qt::Key_aacute:
      case Qt::Key_acircumflex:
      case Qt::Key_atilde:
      case Qt::Key_adiaeresis:
      case Qt::Key_aring:
      case Qt::Key_ae:
      case Qt::Key_ccedilla:
      case Qt::Key_egrave:
      case Qt::Key_eacute:
      case Qt::Key_ecircumflex:
      case Qt::Key_ediaeresis:
      case Qt::Key_igrave:
      case Qt::Key_iacute:
      case Qt::Key_icircumflex:
      case Qt::Key_idiaeresis:
      case Qt::Key_eth:
      case Qt::Key_ntilde:
      case Qt::Key_ograve:
      case Qt::Key_oacute:
      case Qt::Key_ocircumflex:
      case Qt::Key_otilde:
      case Qt::Key_odiaeresis:
      case Qt::Key_division:
      case Qt::Key_oslash:
      case Qt::Key_ugrave:
      case Qt::Key_uacute:
      case Qt::Key_ucircumflex:
      case Qt::Key_udiaeresis:
      case Qt::Key_yacute:
      case Qt::Key_thorn:
      case Qt::Key_ydiaeresis:
       return 0;
    }

    return 0;
}

enum IIIMF_MODIFIERS {
	IIIMF_SHIFT_MODIFIER = 1,
	IIIMF_CONTROL_MODIFIER = 2,
	IIIMF_META_MODIFIER = 4,
	IIIMF_ALT_MODIFIER = 8
};

static int
modifier(
    QKeyEvent *e
)
{
    int mod = 0;
    int st = e->state();

    if (st & Qt::ShiftButton) {
	mod |= IIIMF_SHIFT_MODIFIER;
    }
    if (st & Qt::ControlButton) {
	mod |= IIIMF_CONTROL_MODIFIER;
    }
    if (st & Qt::MetaButton) {
	mod |= IIIMF_META_MODIFIER;
    }
    if (st & Qt::AltButton) {
	mod |= IIIMF_ALT_MODIFIER;
    }

    return mod;
}
    

IIIMF_status
convert_QKeyEvent_to_IIIMCF_keyevent(
    QKeyEvent *e,
    IIIMCF_keyevent *pkev
)
{
    int c;

    c = q2icode(e);
    if (c == 0) return IIIMF_STATUS_FAIL;

    if (c < 0) {
	pkev->keychar = 0;
	pkev->keycode = -c;
    } else {
	pkev->keychar = e->ascii();
	pkev->keycode = c;
    }
    pkev->modifier = modifier(e);

    QTime t = QTime::currentTime();
    pkev->time_stamp = t.msec();

    return IIIMF_STATUS_SUCCESS;
}

static int
i2qcode(
    int iiimcode
)
{
    switch (iiimcode) {
      case IIIMF_KEYCODE_UNDEFINED:
       return 0;
      case IIIMF_KEYCODE_CANCEL:
       return 0;
      case IIIMF_KEYCODE_BACK_SPACE:
       return Qt::Key_Backspace;
      case IIIMF_KEYCODE_TAB:
       return Qt::Key_Tab;
      case IIIMF_KEYCODE_ENTER:
       return Qt::Key_Enter;
      case IIIMF_KEYCODE_CLEAR:
       return Qt::Key_Clear;
      case IIIMF_KEYCODE_SHIFT:
       return Qt::Key_Shift;
      case IIIMF_KEYCODE_CONTROL:
       return Qt::Key_Control;
      case IIIMF_KEYCODE_ALT:
       return Qt::Key_Alt;
      case IIIMF_KEYCODE_PAUSE:
       return Qt::Key_Pause;
      case IIIMF_KEYCODE_CAPS_LOCK:
       return Qt::Key_CapsLock;
      case IIIMF_KEYCODE_KANA:
      case IIIMF_KEYCODE_FINAL:
      case IIIMF_KEYCODE_KANJI:
       return 0;
      case IIIMF_KEYCODE_ESCAPE:
       return Qt::Key_Escape;
      case IIIMF_KEYCODE_CONVERT:
      case IIIMF_KEYCODE_NONCONVERT:
      case IIIMF_KEYCODE_ACCEPT:
      case IIIMF_KEYCODE_MODECHANGE:
       return 0;
      case IIIMF_KEYCODE_SPACE:
       return Qt::Key_Space;
      case IIIMF_KEYCODE_PAGE_UP:
       return Qt::Key_Prior;
      case IIIMF_KEYCODE_PAGE_DOWN:
       return Qt::Key_Next;
      case IIIMF_KEYCODE_END:
       return Qt::Key_End;
      case IIIMF_KEYCODE_HOME:
       return Qt::Key_Home;
      case IIIMF_KEYCODE_LEFT:
       return Qt::Key_Left;
      case IIIMF_KEYCODE_UP:
       return Qt::Key_Up;
      case IIIMF_KEYCODE_RIGHT:
       return Qt::Key_Right;
      case IIIMF_KEYCODE_DOWN:
       return Qt::Key_Down;
      case IIIMF_KEYCODE_COMMA:
       return Qt::Key_Comma;
      case IIIMF_KEYCODE_MINUS:
       return Qt::Key_Minus;
      case IIIMF_KEYCODE_PERIOD:
       return Qt::Key_Period;
      case IIIMF_KEYCODE_SLASH:
       return Qt::Key_Slash;

      case IIIMF_KEYCODE_0:
      case IIIMF_KEYCODE_1:
      case IIIMF_KEYCODE_2:
      case IIIMF_KEYCODE_3:
      case IIIMF_KEYCODE_4:
      case IIIMF_KEYCODE_5:
      case IIIMF_KEYCODE_6:
      case IIIMF_KEYCODE_7:
      case IIIMF_KEYCODE_8:
      case IIIMF_KEYCODE_9:

      case IIIMF_KEYCODE_SEMICOLON:
      case IIIMF_KEYCODE_EQUALS:

      case IIIMF_KEYCODE_A:
      case IIIMF_KEYCODE_B:
      case IIIMF_KEYCODE_C:
      case IIIMF_KEYCODE_D:
      case IIIMF_KEYCODE_E:
      case IIIMF_KEYCODE_F:
      case IIIMF_KEYCODE_G:
      case IIIMF_KEYCODE_H:
      case IIIMF_KEYCODE_I:
      case IIIMF_KEYCODE_J:
      case IIIMF_KEYCODE_K:
      case IIIMF_KEYCODE_L:
      case IIIMF_KEYCODE_M:
      case IIIMF_KEYCODE_N:
      case IIIMF_KEYCODE_O:
      case IIIMF_KEYCODE_P:
      case IIIMF_KEYCODE_Q:
      case IIIMF_KEYCODE_R:
      case IIIMF_KEYCODE_S:
      case IIIMF_KEYCODE_T:
      case IIIMF_KEYCODE_U:
      case IIIMF_KEYCODE_V:
      case IIIMF_KEYCODE_W:
      case IIIMF_KEYCODE_X:
      case IIIMF_KEYCODE_Y:
      case IIIMF_KEYCODE_Z:

      case IIIMF_KEYCODE_OPEN_BRACKET:
      case IIIMF_KEYCODE_BACK_SLASH:
      case IIIMF_KEYCODE_CLOSE_BRACKET:
       return iiimcode;

      case IIIMF_KEYCODE_NUMPAD0:
      case IIIMF_KEYCODE_NUMPAD1:
      case IIIMF_KEYCODE_NUMPAD2:
      case IIIMF_KEYCODE_NUMPAD3:
      case IIIMF_KEYCODE_NUMPAD4:
      case IIIMF_KEYCODE_NUMPAD5:
      case IIIMF_KEYCODE_NUMPAD6:
      case IIIMF_KEYCODE_NUMPAD7:
      case IIIMF_KEYCODE_NUMPAD8:
      case IIIMF_KEYCODE_NUMPAD9:
      case IIIMF_KEYCODE_MULTIPLY:
      case IIIMF_KEYCODE_ADD:
      case IIIMF_KEYCODE_SEPARATOR:
       //case IIIMF_KEYCODE_SEPARATER:
      case IIIMF_KEYCODE_SUBTRACT:
      case IIIMF_KEYCODE_DECIMAL:
      case IIIMF_KEYCODE_DIVIDE:
       return iiimcode;

      case IIIMF_KEYCODE_F1:
       return Qt::Key_F1;
      case IIIMF_KEYCODE_F2:
       return Qt::Key_F2;
      case IIIMF_KEYCODE_F3:
       return Qt::Key_F3;
      case IIIMF_KEYCODE_F4:
       return Qt::Key_F4;
      case IIIMF_KEYCODE_F5:
       return Qt::Key_F5;
      case IIIMF_KEYCODE_F6:
       return Qt::Key_F6;
      case IIIMF_KEYCODE_F7:
       return Qt::Key_F7;
      case IIIMF_KEYCODE_F8:
       return Qt::Key_F8;
      case IIIMF_KEYCODE_F9:
       return Qt::Key_F9;
      case IIIMF_KEYCODE_F10:
       return Qt::Key_F10;
      case IIIMF_KEYCODE_F11:
       return Qt::Key_F11;
      case IIIMF_KEYCODE_F12:
       return Qt::Key_F12;

      case IIIMF_KEYCODE_DELETE:
       return Qt::Key_Delete;
      case IIIMF_KEYCODE_DEAD_GRAVE:
      case IIIMF_KEYCODE_DEAD_ACUTE:
      case IIIMF_KEYCODE_DEAD_CIRCUMFLEX:
      case IIIMF_KEYCODE_DEAD_TILDE:
      case IIIMF_KEYCODE_DEAD_MACRON:
      case IIIMF_KEYCODE_DEAD_BREVE:
      case IIIMF_KEYCODE_DEAD_ABOVEDOT:
      case IIIMF_KEYCODE_DEAD_DIAERESIS:
      case IIIMF_KEYCODE_DEAD_ABOVERING:
      case IIIMF_KEYCODE_DEAD_DOUBLEACUTE:
      case IIIMF_KEYCODE_DEAD_CARON:
      case IIIMF_KEYCODE_DEAD_CEDILLA:
      case IIIMF_KEYCODE_DEAD_OGONEK:
      case IIIMF_KEYCODE_DEAD_IOTA:
      case IIIMF_KEYCODE_DEAD_VOICED_SOUND:
      case IIIMF_KEYCODE_DEAD_SEMIVOICED_SOUND:
       return 0;

      case IIIMF_KEYCODE_NUM_LOCK:
       return Qt::Key_NumLock;
      case IIIMF_KEYCODE_SCROLL_LOCK:
       return Qt::Key_ScrollLock;
      case IIIMF_KEYCODE_AMPERSAND:
       return Qt::Key_Ampersand;
      case IIIMF_KEYCODE_ASTERISK:
       return Qt::Key_Asterisk;
      case IIIMF_KEYCODE_QUOTEDBL:
       return Qt::Key_QuoteDbl;
      case IIIMF_KEYCODE_LESS:
       return Qt::Key_Less;
      case IIIMF_KEYCODE_PRINTSCREEN:
       return Qt::Key_Print;
      case IIIMF_KEYCODE_INSERT:
       return Qt::Key_Insert;
      case IIIMF_KEYCODE_HELP:
       return Qt::Key_Help;
      case IIIMF_KEYCODE_META:
       return Qt::Key_Meta;
      case IIIMF_KEYCODE_GREATER:
       return Qt::Key_Greater;
      case IIIMF_KEYCODE_BRACELEFT:
       return Qt::Key_BraceLeft;
      case IIIMF_KEYCODE_BRACERIGHT:
       return Qt::Key_BraceRight;

      case IIIMF_KEYCODE_BACK_QUOTE:
      case IIIMF_KEYCODE_QUOTE:
      case IIIMF_KEYCODE_KP_UP:
      case IIIMF_KEYCODE_KP_DOWN:
      case IIIMF_KEYCODE_KP_LEFT:
      case IIIMF_KEYCODE_KP_RIGHT:
      case IIIMF_KEYCODE_ALPHANUMERIC:
      case IIIMF_KEYCODE_KATAKANA:
      case IIIMF_KEYCODE_HIRAGANA:
      case IIIMF_KEYCODE_FULL_WIDTH:
      case IIIMF_KEYCODE_HALF_WIDTH:
      case IIIMF_KEYCODE_ROMAN_CHARACTERS:
      case IIIMF_KEYCODE_ALL_CANDIDATES:
      case IIIMF_KEYCODE_PREVIOUS_CANDIDATE:
      case IIIMF_KEYCODE_CODE_INPUT:
      case IIIMF_KEYCODE_JAPANESE_KATAKANA:
      case IIIMF_KEYCODE_JAPANESE_HIRAGANA:
      case IIIMF_KEYCODE_JAPANESE_ROMAN:
      case IIIMF_KEYCODE_KANA_LOCK:
      case IIIMF_KEYCODE_INPUT_METHOD_ON_OFF:
      case IIIMF_KEYCODE_AT:
      case IIIMF_KEYCODE_COLON:
      case IIIMF_KEYCODE_CIRCUMFLEX:
      case IIIMF_KEYCODE_DOLLAR:
      case IIIMF_KEYCODE_EURO_SIGN:
      case IIIMF_KEYCODE_EXCLAMATION_MARK:
      case IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK:
      case IIIMF_KEYCODE_LEFT_PARENTHESIS:
      case IIIMF_KEYCODE_NUMBER_SIGN:
      case IIIMF_KEYCODE_PLUS:
      case IIIMF_KEYCODE_RIGHT_PARENTHESIS:
      case IIIMF_KEYCODE_UNDERSCORE:
       return 0;

      case IIIMF_KEYCODE_F13:
       return Qt::Key_F13;
      case IIIMF_KEYCODE_F14:
       return Qt::Key_F14;
      case IIIMF_KEYCODE_F15:
       return Qt::Key_F15;
      case IIIMF_KEYCODE_F16:
       return Qt::Key_F16;
      case IIIMF_KEYCODE_F17:
       return Qt::Key_F17;
      case IIIMF_KEYCODE_F18:
       return Qt::Key_F18;
      case IIIMF_KEYCODE_F19:
       return Qt::Key_F19;
      case IIIMF_KEYCODE_F20:
       return Qt::Key_F20;
      case IIIMF_KEYCODE_F21:
       return Qt::Key_F21;
      case IIIMF_KEYCODE_F22:
       return Qt::Key_F22;
      case IIIMF_KEYCODE_F23:
       return Qt::Key_F23;
      case IIIMF_KEYCODE_F24:
       return Qt::Key_F24;

      case IIIMF_KEYCODE_COMPOSE:
      case IIIMF_KEYCODE_ALT_GRAPH:
      case IIIMF_KEYCODE_STOP:
      case IIIMF_KEYCODE_AGAIN:
      case IIIMF_KEYCODE_PROPS:
      case IIIMF_KEYCODE_UNDO:
      case IIIMF_KEYCODE_COPY:
      case IIIMF_KEYCODE_PASTE:
      case IIIMF_KEYCODE_FIND:
      case IIIMF_KEYCODE_CUT:
       return 0;
    }

    return 0;
}

IIIMF_status
convert_IIIMCF_keyevent_to_QKeyEvent(
    IIIMCF_keyevent *pkev,
    int pressp,
    QKeyEvent **pe
)
{
    int c, s;

    c = i2qcode(pkev->keycode);

    if (!c) return IIIMF_STATUS_FAIL;

    s = 0;
    if (pkev->modifier & IIIMF_SHIFT_MODIFIER) {
	s |= Qt::ShiftButton;
    }
    if (pkev->modifier & IIIMF_CONTROL_MODIFIER) {
	s |= Qt::ControlButton;
    }
    if (pkev->modifier & IIIMF_META_MODIFIER) {
	s |= Qt::MetaButton;
    }
    if (pkev->modifier & IIIMF_ALT_MODIFIER) {
	s |= Qt::AltButton;
    }

    if (pressp)
	*pe = new QKeyEvent(QEvent::KeyPress, c, pkev->keychar, s);
    else
	*pe = new QKeyEvent(QEvent::KeyRelease, c, pkev->keychar, s);

    return IIIMF_STATUS_SUCCESS;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
