#if !defined(IIIMF_INPUT_METHOD_H)
#define IIIMF_INPUT_METHOD_H


#include <iiimp-data.h>

#include "sequence.h"
#include "stream.h"
#include "role-data-client.h"
#include "role-data-server.h"


#ifdef	__cplusplus
extern "C" {
#endif


struct iiimf_im {
    int				im_id;

    union {
	IIIMF_role_data_client *	client;
	IIIMF_role_data_server *	server;
    }				role_data;

    IIIMP_data_s *		data_s;

    int				role;
    int				state;
    IIIMF_message_pending *	message_pending;
    int				message_depth;
    int				message_depth_maximum;

    IIIMF_message_handler_call_func	message_handler_call;
    IIIMF_message_handler_entry **	message_handler;

    IIIMF_ic *			ic_list;

    IIIMF_stream *		stream;

    IIIMP_string *		language_list;

    void *			client_data;	/* used by application */
};


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMF_INPUT_METHOD_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
