#
# spec file for package libchewing (Version 0.2.5)
#
# Copyright (c) 2005 Sun Microsystems, Inc.
#

# norootforbuild
# neededforbuild  

%define version 0.2.6
%define release 0.1

Summary:	The Chewing intelligent phonetic input method library
Name:		libchewing
Version:	%{version}
Release:	%{release}
License:	LGPL
Group:		System/Libraries
URL:		http://chewing.csie.net
Buildroot:      %_tmppath/%{name}-%{version}-%{release}-root

Source:		%{name}-%{version}.tar.gz
Patch1:		libchewing-debug.diff

BuildRequires: aaa_base acl attr bash bind-utils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv less libacl libattr libgcc libselinux libstdc++ libxcrypt m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procps psmisc pwdutils rcs readline sed strace syslogd sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils gcc gdbm gettext libtool perl rpm

%description
This is an intelligent Chinese phonetic input method library. Based on
Chewing input method.

%package	-n %{name}-devel
Summary:	Header files and libraries for developing apps which will use libchewing
Group:		Development/C
Requires:	%{name} = %{version}
Provides:	%{name}-devel = %{version}-%{release}

%description	-n %{name}-devel
Header files and libraries for developing apps which will use libchewing

%prep
%setup -q %{name}-%{version}
%patch1 -p1

%build
CONFIGURE_TOP="${CONFIGURE_TOP:-.}"; \
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ; \
CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ; \
FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ; \
%{?__libtoolize:(cd $CONFIGURE_TOP; [ -f configure.in -o -f configure.ac ] && %{__libtoolize} --copy)} ; \
$CONFIGURE_TOP/configure --build=%{_target_platform} \
      --prefix=%{_prefix} \
      --exec-prefix=%{_exec_prefix} \
      --bindir=%{_bindir} \
      --sbindir=%{_sbindir} \
      --sysconfdir=%{_sysconfdir} \
      --datadir=%{_datadir} \
      --includedir=%{_includedir} \
      --libdir=%{_libdir} \
      --libexecdir=%{_libexecdir} \
      --localstatedir=%{_localstatedir} \
      --sharedstatedir=%{_sharedstatedir} \
      --mandir=%{_mandir} \
      --infodir=%{_infodir}
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;
make DESTDIR=${RPM_BUILD_ROOT} install

%clean
#[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;

%post -n %{name} -p /sbin/ldconfig
%postun -n %{name} -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so
%{_libdir}/*.so.*
%{_datadir}/*

%files -n %{name}-devel
%defattr(-, root, root)
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/*
%{_libdir}/pkgconfig/chewing.pc

%changelog
* Thu Jan 12 2005 Hidetoshi Tajima <hidetoshi.tajima@sun.com>
- modify the spec for using on JDS3

* Fri Aug 06 2004 Shiva Huang <blueshiva@giga.net.tw> 0.2.2-1mdk
- Initial release.
