""" Custom error handling module

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: Error.py,v 1.8 2003/09/07 14:00:06 niederberger Exp $        

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.8 $"

import traceback,sys

def ExcptHandler(type,value,tback):
    """User friendly error handling """
    print "--------- Traceback ------------------"
    traceback.print_exception(type, value, tback)
    print "--------------------------------------"	
    print "You have found a bug, please help us by submitting the text above and a precise description of how you caused it to \"http://imgseek.sourceforge.net/bugs\""

def qtImportError():
    traceback.print_exc()
    print "You system doesn't seem to have PyQT installed. Please install it before running this application. Please, see http://www.riverbankcomputing.co.uk/pyqt/download.php"
    sys.exit()


def PrintTB(reason = None):
    """User friendly error handling. Call at will when needed """
    print "--------- Traceback ------------------"
    traceback.print_exc()
    if reason:
        print "Cause: ",reason
    print "--------------------------------------"	
    print "You have found a bug, please help us by submitting the text above and a precise description of how you caused it to \"http://imgseek.sourceforge.net/bugs\""
