/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DIRECTORYMODEL_H
#define DIRECTORYMODEL_H

#include <qstring.h>
#include <qvaluevector.h>
#include <kurl.h>

#define CATNAME_ARTISTS "Artists"
#define CATNAME_PLAYLISTS "Playlists"
#define CATNAME_UTILS "Utilities"
#define CATNAME_TRANSFER "Transfer - drop stuff here"

/**
Represents the directory tree

@author Michael Schulze
*/
class DirectoryModel{
public:

    enum Category {
        Artists,
        Playlists,
        Utilites,
        Transfer,
        NumCategories
    };
    
    enum Type {
        ROOT,
        IPOD,
        CATEGORY,
        ARTIST,
        ALBUM,
        PLAYLIST,
        UTILITY,
        TRACK,
        UNKNOWN= 255
    } type;
    
    bool isFile;
    const QString& getUtilityName() const;
    const QString& getPlaylist() const;
    const QString& getIPodName() const;
    Category getCategory() const;
    static const QString& getCategoryName( Category category);
    const QString& getArtist() const;
    const QString& getAlbum() const;
    const QString& getTrack() const;

    bool isMkDirAllowed() const;
    bool isDeleteAllowed() const;
    bool isRenameAllowed() const;
    bool isCopyAllowed() const;
    bool isFileExtSupported() const;

    bool ignoreMkDir() const;

    DirectoryModel();
    DirectoryModel( const KURL& kurl);
    virtual ~DirectoryModel();

    void parseUrl( const KURL& url);

    /**
     * returns the name of the current directory
     */
    const QString& getCurrentDirectory() const;

    /**
     * returns the last path element in the url
     */
    const QString& getFilename() const;

    /**
     * returns the file extension if the given URL is a file
     */
    QString getFileExtension() const;

protected:
    enum Index {
        ROOT_IDX= -1,
        IPOD_IDX = 0,
        CATEGORY_IDX= 1,
        ARTIST_IDX= 2,
        PLAYLIST_IDX= 2,
        UTILITY_IDX= 2,
        ALBUM_IDX= 3
    };

    Category category;

    QValueVector<QString> dircomponents;
    static const QString categoryNames[];
};

#endif
