/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2003 Ross Axe                                     *
*                                                       *
* browser.c - frontend for irmp3 browser module         *
\*******************************************************/

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include "irmp3-ncurses.h"

vcid("$Id: browser.c,v 1.25 2005/12/30 12:46:47 ross Exp $");

WINDOW *brwnd;


/*
 * browser_init
 * set everything up nicely
 */
void browser_init(int sock)
{
    if(show_playlist) {
	brwnd = newwin(3, PLAYLIST_LEFT - 1, STATE_TOP + STATE_HEIGHT, 0);
    } else {
	brwnd = newwin(3, getmaxx(stdscr), STATE_TOP + STATE_HEIGHT, 0);
    }
    printtitlebar(brwnd, _("Browser"), NULL);
    wrefresh(brwnd);
    netputs("browser show", sock);
}

/*
 * browser_exit
 * clean up everything done in browser_init
 */
static void browser_exit(void)
{
    WINDOW *const tmp = brwnd;

    brwnd = NULL;
    wclear(tmp);
    wrefresh(tmp);
    delwin(tmp);
}

static void showbrowserhelp(void)
{
    sbar_printf(_("Browser keystroke help:"));
    sbar_printf(_("Up/Down/Pg Up/Pg Dn: Move browser cursor  Enter: add selection to playlist"));
    sbar_printf(_("Left: parent directory  Right: enter directory  b/q: hide browser"));
    sbar_printf(_("c: clear playlist and stop  ?: help  q: quit"));
}

static void print_pwd(const char *pwd)
{
    printtitlebar(brwnd, _("Browser"), " - %s", pwd);
    wrefresh(brwnd);
}

static void print_cursor(const char *cursor)
{
    mvwaddstr(brwnd, 1, 0, cursor);
    wclrtobot(brwnd);
    wrefresh(brwnd);
}

static bool handle_browser(int sock, char *buf, int class)
{
    if(strstart("pwd ", buf))
	print_pwd(buf + 4);
    else if(strstart("cursor ", buf))
	print_cursor(buf + 7);
    else if(strstart("cursorpos ", buf)) {
	int h, w;

	getmaxyx(brwnd, h, w);
	mvwprintslider(brwnd, 2, 0, w, atol(buf + 10), 0, 99);
	wrefresh(brwnd);
    } else if(strstart("info ", buf)) {
	playlist_dirty(sock);
    } else {
	sbar_printf(_("Unknown browser message: %d: browser %s"), class, buf);
	return true;
    }
    return true;
}


bool browser_net_callback(int sock, char *buf)
{
#if SUPPORT_04X
    if(strstart("230: browser ", buf))
	return handle_browser(sock, buf + 13, 230);
#endif
#if SUPPORT_05X
    if(strstart("220: browser ", buf))
	return handle_browser(sock, buf + 13, 220);
#endif

    return main_net_callback(sock, buf);
}


bool browser_key_callback(int sock, int chr)
{
    switch(chr) {
    case '?':
	showbrowserhelp();
	break;
    case 'q':
    case 'b':
    case 3:			/* ctrl+C */
    case 4:			/* ctrl+D */
	browser_exit();
	break;
    case KEY_UP:
	netputs("browser cursor -1", sock);
	break;
    case KEY_DOWN:
	netputs("browser cursor +1", sock);
	break;
    case KEY_PPAGE:
	netputs("browser cursor -10", sock);
	break;
    case KEY_NPAGE:
	netputs("browser cursor +10", sock);
	break;
#ifdef PADENTER
    case PADENTER:
#endif
    case KEY_ENTER:
    case '\r':			/* 'enter' key */
	netputs("browser add", sock);
	break;
    case KEY_RIGHT:
	netputs("browser into", sock);
	break;
    case KEY_LEFT:
	netputs("browser back", sock);
	break;
    case 'c':
	netputs("browser clear", sock);
	break;
    default:
	return false;
    }
    return true;
}
