////
///  genfisuffix - a Finnish affix table generator for ispell
//   Copyright (C) 2000  Pauli Virtanen <pauli.virtanen@saunalahti.fi>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//   The program's output is also subject to this license, and considered
//   program source code.
//
//////////////////////////////////////////////////////////////////////////////
//
//
#ifndef FINNISH_DATA_HH_
#define FINNISH_DATA_HH_

/// Data
///
extern vector<string> possessive_suffixes;
extern vector<string> suffix_particles;
extern vector<string> case_suffixes;
extern vector<string> case_possessivable_suffixes;
extern vector<string> passive_suffixes;
extern vector<string> suffix_particles_verbs;

// These are the suffix particles attached to negative and imperative forms
// of verbs.
extern vector<string> negative_suffix_particles;
extern vector<string> imperative_suffix_particles;


/// Functions
///
void init_finnish_data();

void do_adjectives();

void do_suffix_particles();
void do_nouns();
void do_possessive_and_illative();

void do_verbs_infinitive_stem();
void do_verbs_declination_stem();
void do_verbs_consonant_gradated_declination_stem();

#endif
