
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: manager.h,v 1.16 2007/01/29 11:52:31 makoenig Exp $
 *****************************************************************************/

#ifndef _MANAGER_H
#define _MANAGER_H

void ivm_device_mount(char const *const udi);
void ivm_media_changed(char const *const udi);
void ivm_load_config();
void ivm_sighup_handler(int const sig);
void ivm_umount_if_needed(char const *const mountpoint);

char *ivm_get_config_file(char const *const filename);
gboolean ivm_run_command(char const *const command, char const *udi,
                         gboolean const execun);

// Run an array of commands
void ivm_run_commands(char **commands, char const *udi,
                      gboolean const execun);

// Free an array of strings
void ivm_free_str_array(char **strings);

void setupHAL(void);

#endif
