%define name ivritex
%define version 1.1.1
#%define heblatex_ver 2.3d
#%define hebbib_ver 1.0
%define release 2
%define url http://ivritex.sf.net/

# A hack: install heblatex under texmf/tex/generic/0ivritex/
# this will make it override the conflicting version in 
# texmf/generic/babel/
# remove this definition once there is no need for it
%define texmfdir %{_datadir}/texmf
%define hebbib_dir       %{texmfdir}/bibtex/ivritex
%define heblatex_dir     %{texmfdir}/tex/generic/0ivritex
%define heblatex_doc_dir %{texmfdir}/doc/generic/0ivritex
%define hebclass_dir     %{texmfdir}/tex/latex/hebclass
%define hebclass_doc_dir %{texmfdir}/doc/latex/hebclass

Summary: Files for processing Hebrew LaTeX documents
name: %{name}
Version: %{version}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
# # from CTAN
# Source1: hebexmpl.tar.bz2
# Source2: heblatex-%{heblatex_ver}.tar.gz
# # from CTAN
# Source3: hebfonts.tar.gz
# # hebrew bibtex styles, by Dekel Tsur
# Source4: hebbib-%{hebbib_ver}.tar.gz
# #Source2: tetex-heb-ttf-support.tar.bz2
# #Source1: bibtex-heb.tar.bz2
# copied verbatim from Mandrake's tetex package:
License: LPPL
Group: Publishing
BuildRoot: %{_tmppath}/%{name}-buildroot
# what tetex version is required, exactly? requires babel >=3.6j
Obsoletes: tetex-latex-heb
# currently the fonts package is back inside the main package:
Obsoletes: tetex-latex-heb-fonts, ivritex-fonts
Requires: tetex > 0.9
# For creating the docs: It requires the command 'elatex' Actually 
# 'latex' will do with some minor tweaking of latex/heblatex/Makefile
# dvips is also needed
BuildRequires: tetex-latex tetex-dvips
#Requires: %{name}-fonts = %{version}
BuildArch: noarch
URL: %{url}

%description
IvriTeX is a package to add Hebrew support to LaTeX. LaTeX is a system for
typesetting high-quality documents. It takes .tex text files as input and
produces DVI (DeVice Independent) document as output, which can be printed, or
converted to PostScript or PDF documents. IvriTeX allows the use of Hebrew
within LaTeX docoments.

Install ivritex if you want to allow formating of Hebrew LaTeX
documents, or Hebrew LyX documents.

%package doc
Group: Publishing
Summary: dcumentation and samples for the Hebrew LaTeX package
Obsoletes: tetex-latex-heb-doc
Requires: %{name} = %{version}

%description doc
IvriTeX is a package to add Hebrew support to LaTeX. LaTeX is a system for
typesetting high-quality documents. It takes .tex text files as input and
produces DVI (DeVice Independent) document as output, which can be printed, or
converted to PostScript or PDF documents. IvriTeX allows the use of Hebrew
within LaTeX docoments.

This package includes documentation and sample Hebrew tex documents for the 
Hebrew support for babel/LaTeX 2e

%prep
%setup
#extract hebexampl, heblatex and hebfonts archives inside build dir
#%setup -a 1 -a 2 -a 3 -a 4 
#mv hebrew hebfonts

#TODO: put this in a seperate file
cat <<EOF >README.rpm
The Ivritex package includes the files needed for Hebrew support in LaTeX.
It is split into two subpackages:

 * ivritex: The Hebrew LaTeX files
 * ivritex-doc: some extra documentation and samples and the sources
                of the original packages

You need to install both ivritex and ivritex-Fonts to be able to typeset
Hebrew documents. ivritex-doc contains some useful document samples, as well
as the "sources" of the hebrew latex files and of the documentation.

This package includes one sample document, to enable you to test your
installation:

run (from a directory that you can write in):

  elatex %{_docdir}/hebhello.tex

Many messages will appear. If all was well, a file called hebhello.dvi will be
created in the current directory. You should be able to view it using:

  xdvi test-heb

After some more procesisng and output to the terminal, a document with one
line, ", World!" ("Shalom World!") should appear. press 'q' to quit.

For more information and documentation see the package ivritex-doc or 
http://ivritex.sf.net/
EOF

cp -r latex/heblatex heblatex_sources
cp -r latex/hebclass hebclass_sources

%build
cp -r example example_orig

#cd heblatex-%{heblatex_ver}
# Chances are that setting PREFIX is not necessary here.
# Also: maybe setting TEX_ROOT would be more correct
make PREFIX=%{_prefix}

# Copy all the documents that were generated from the examples into 
# the tree of examples_orig
for doc in $( find example -name '*.ps' -o -name '*.pdf' ); do 
  newname=`echo ${doc} |sed -e 's/example/example_orig/'`
  cp ${doc} ${newname} 
done

# now swap the two:
mv example example_new
mv example_orig example

%install
rm -rf $RPM_BUILD_ROOT

make PREFIX=${RPM_BUILD_ROOT}%{_prefix} install
# rm -rf $RPM_BUILD_ROOT
# 
# cd heblatex-%{heblatex_ver}
# make PREFIX=$RPM_BUILD_ROOT%{_prefix} \
#      HEBREW_TARGET_DIR=$RPM_BUILD_ROOT%{heblatex_dir} \
#      install
# cd ..
# 
# install -m 755 -d         $RPM_BUILD_ROOT%{texmfdir}/bibtex/bst/base
# install -m 644 hebbib/*   $RPM_BUILD_ROOT%{texmfdir}/bibtex/bst/base/
# install -m 755 -d         $RPM_BUILD_ROOT%{texmfdir}/fonts/source/hebrew
# install -m 644 hebfonts/* $RPM_BUILD_ROOT%{texmfdir}/fonts/source/hebrew/
# 
# 
# #install -d $RPM_BUILD_ROOT%{_datadir}/
# #cp -R texmf $RPM_BUILD_ROOT%{_datadir}/
# #ln -s $RPM_BUILD_ROOT%{texmfdir}/fonts/tfm/truetype/ \
# #      $RPM_BUILD_ROOT%{texmfdir}/fonts/truetype/tex/tfm


%post 
mktexlsr

%postun
mktexlsr

%clean
rm -rf $RPM_BUILD_ROOT

%files 
%defattr(-,root,root,0755)  
%doc README.rpm example/tests/hebhello.tex
%{heblatex_dir}/*.def
%{heblatex_dir}/hebrew*
%{heblatex_dir}/hebcal.sty
%{hebclass_dir}/*.cls
%{hebclass_dir}/tcourse.sty
%{hebbib_dir}/*.bst
# originally from the fonts subpackage:
%{heblatex_dir}/lhe*.fd
%{heblatex_dir}/he8*.fd
%{heblatex_dir}/hebfont.sty
%{texmfdir}/fonts/tfm/omegahe8/OmegaHebrew.tfm
%{texmfdir}/fonts/afm/omegahe8/OmegaHebrew.afm
%{texmfdir}/fonts/type1/omegahe8/OmegaHebrew.*
%{texmfdir}/fonts/source/hebrew/crm*.mf
%{texmfdir}/fonts/source/hebrew/deads10.mf
%{texmfdir}/fonts/source/hebrew/fr*.mf
%{texmfdir}/fonts/source/hebrew/hc*.mf
%{texmfdir}/fonts/source/hebrew/he*.mf
%{texmfdir}/fonts/source/hebrew/jerus10.mf
%{texmfdir}/fonts/source/hebrew/oldjaf10.mf
%{texmfdir}/fonts/source/hebrew/redis*.mf
%{texmfdir}/fonts/source/hebrew/sh*.mf
%{texmfdir}/fonts/source/hebrew/telav10.mf
#%{texmfdir}/fonts/truetype/

%files doc
%defattr(-,root,root,0755) 
#%doc example README.html README.txt heblatex-%{heblatex_ver}/BUGS.txt
# TODO: this list is not complete!!!
%doc README latex/heblatex/README.html latex/heblatex/BUGS.txt
%doc heblatex_sources hebclass_sources example
# only to make the makefiles of the examples work:
%doc ivritex.mk
%doc %{heblatex_doc_dir}
%doc %{hebclass_doc_dir}


%changelog
* Thu Jan 16 2003 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.1-1
- Added hebclass sources to the -doc package
- removed unnecessary files from the examples tree in -docs

* Thu Jan 16 2003 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0.1-1
- Added BuildRequires (latex, dvips)
- Fixed BuiildArch tag
- Removed the fonts subpackage
- Added hebclass files (separate dirs)
- Fixed description (still not optimal)
- License

* Wed Feb 13 2002 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0-5
- A complitely new package. Called ivritex. Using "make install". 
- spec updated from makefile
- ivritex tarball does all the work (all we need is 'make; make install)
- changed localtion of babel files to tex/generic/0ivritex, as per ivritex
- added he8 encoding files
- adding OmegaHebrew
- removed some documentation temporarily
- more up-to-date heblatex from current CVS
- fonts does not require main package installed

* Sun Jan  6 2002 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0-4
- actually moved fonts files to fonts subpackage

* Fri Jan  4 2002 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0-3
- updated heblatex to 2.3d

* Fri Nov  9 2001 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0-2
- Added post scripts for -fonts, to run mktexlsr

* Thu Nov  1 2001 Tzafrir Cohen <tzafrir@technion.ac.il> 1.1.0-1haifux
- hebfonts is now the original tarball
- hebbib in a seperate package
- a seperate -fonts package
- a hack to make it override files from babel 3.7

* Mon Jul  9 2001 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0.3-1
- heblatex 2.3b
- The rpm now contains a properly-named tar-ball

* Mon Jul  9 2001 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0.3-1
- heblatex 2.3a
- documentation is produced for heblatex (in the doc package)

* Wed Feb 28 2001 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0.2-2
- moved heblatex as a seperate source (also worked around heblatex build bug)

* Fri Dec  8 2000 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0.2-1
- Used sources of the heblatex package. There is a build step
- a change of the tex package: prefixed all hebrew letters with "heb"

* Sat Nov  18 2000 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0.1-1
- merged everything into the tarball (including bibtex)
- added the hebexampl tarball as a -doc package
- added some corrections from the IVRITEX mailing list (also in the tarball)
- added ttfsupport tarball

* Mon May  1 2000 Tzafrir Cohen <tzafrir@technion.ac.il>
- Added some bibtex files
- Added postun script
- moved to group Applications/Publishing

* Thu Apr 20 2000 Warly <warly@mandrakesoft.com> 1.0-2mdk
- change group: Publishing

* Sat Feb 5 2000 Tzafrir Cohen <tzafrir@technion.ac.il> 1.0-1mdk
- created the package. Added a README and a test doc
- adapted to MDK by Pablo Saratxaga <pablo@mandrakesoft.com>
