#ifndef _DRAW_EMBED_C
#define _DRAW_EMBED_C

#include "img.c"
#include "signal.c"

void
jackscope_draw_embed_init ( uint8_t *image , int size )
{
  int i ;
  for ( i = 0 ; i < size ; i+=3 ) {
    uint8_t half[3] = { 128 , 128 , 128 } ;
    uint8_t feint[3] = { 192 , 192 , 192 } ;
    img_set_pixel_xy ( image , size , i , size/2 , half ) ;
    img_set_pixel_xy ( image , size , i , size/6 , feint ) ;
    img_set_pixel_xy ( image , size , i , size-(size/6) , feint ) ;
  }
  for ( i = 0 ; i < size ; i+=3 ) {
    uint8_t half[3] = { 128 , 128 , 128 } ;
    uint8_t feint[3] = { 192 , 192 , 192 } ;
    img_set_pixel_xy ( image , size , size/2 , i , half ) ;
    img_set_pixel_xy ( image , size , size/6 , i , feint ) ;
    img_set_pixel_xy ( image , size , size-(size/6) , i , feint ) ;
  }
}

void
jackscope_draw_embed_data ( uint8_t *image , int size , const float *signal , int n , const uint8_t *color , int embed , float incr )
{
  if ( incr <= 0.0 ) {
    incr = 1.0 ;
  }
  float xindex = 0.0 ;
  float yindex = (float) embed ;
  while ( yindex < n ) {
    int x = signal_x_to_screen_x ( signal_interpolate_safe ( signal , n , xindex ) , size ) ;
    int y = signal_y_to_screen_y ( signal_interpolate_safe ( signal , n , yindex ) , size ) ;
    xindex += incr ;
    yindex += incr ;
    img_set_pixel_xy ( image , size , x , y , color ) ;
  }
}

void
jackscope_draw_embed ( uint8_t *image , int size , const float *signal , int f , int d , int c , const uint8_t *color , int embed , float incr )
{
  jackscope_draw_embed_init ( image , size ) ;
  int i ;
  for ( i = 0 ; i < c ; i++ ) {
    jackscope_draw_embed_data ( image , size , signal + ( i * f ) , d , color + ( i * 3 ) , embed , incr ) ;
  }
}

#endif
