#ifndef MONITOR_H__
#define MONITOR_H__

#include <jmp-config.h>
#include <monitor_type.h>

#ifdef JMPDEBUG_MONITOR
/** Create a new monitor */
struct monitor *jmp_create_monitor (char *);

/** Delete a monitor */
void jmp_delete_monitor (struct monitor *);

/** Lock a monitor */
void jmp_lock_monitor (struct monitor *, int);

/** Unlock a monitor */
void jmp_unlock_monitor (struct monitor *, int);

/** Wait for a monitor */
void jmp_monitor_wait (struct monitor *, jlong milis);

/** Notify all waiting for a monitor */
void jmp_monitor_notify_all (struct monitor *);
#else /* JMPDEBUG_MONITOR */

#define jmp_create_monitor(n) jvmpi_create_monitor(n)
#define jmp_delete_monitor(m) jvmpi_delete_monitor(m)
#define jmp_lock_monitor(m, i) jvmpi_lock_monitor(m)
#define jmp_unlock_monitor(m, i) jvmpi_unlock_monitor(m)
#define jmp_monitor_wait(m) jvmpi_monitor_wait(m)
#define jmp_monitor_notify_all(m) jvmpi_monitor_notify_all(m)

#endif /* JMPDEBUG_MONITOR */

#endif   /* MONITOR_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
