#ifndef OBJ_H__
#define OBJ_H__

#include <cls.h>
#include <jmp.h>

/** The structure used to represent an object. */
struct obj {
    jint arena_id;       /** The arena this object is in. */
    cls* clz;            /** the class of this object. */
    jint is_array;       /** Is this object an array? */
    jint size;           /** The number of bytes this instance use. */
    jobjectID obj_id;    /** The id of this object. */
    method* method;      /** The method that alloced this object. */
    int reset_level;     /** The reset level the object was allocated at. */
    int gc_level;        /** The gc level the object was allocated at. */
};

/** Create a new object structure with the given attributes. */
obj* obj_new (jint arena_id, cls* class_id, jint is_array,
	      jint size, jobjectID obj_id, method* m, 
	      int reset_level, int gc_level);

/** Delete the given object structure. */
void obj_free (obj* c);

/** This is the hash function for object structures. */
size_t obj_jmphash_func (void* c, size_t len);

/** Check if two objects are equal. 
 *  return 0 if c1 == c2.
 *  return -1 if c1 < c2.
 *  return 1 if c1 > c2
 */
int obj_cmp_func (void* c1, void* c2);

/** Print some statistics on the given object to stdout. 
 */
void obj_print (obj* c);

/** Get the id of the given object. */
INLINE jobjectID obj_get_object_id (obj* o);

/** Set the id of the given object. */
INLINE void obj_set_object_id (obj* o, jobjectID obj_id);

/** Get the class of the given object. */
INLINE cls* obj_get_class (obj* o);

/** Get the class id of the given object. */
INLINE jobjectID obj_get_class_id (obj* o);

/** Get the size of the given object. */
INLINE jint obj_get_size (obj* o);

/** Set the arena id of the given object. */
INLINE void obj_set_arena_id (obj* o, jint arena_id);

/** Get the reset level that the object was allocated at. */
INLINE int obj_get_reset_level (obj* o);

/** Get the gc level that the object was allocated at. */
INLINE int obj_get_gc_level (obj* o);

#endif /* OBJ_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
