#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jmp.h>
#include <hash.h>
#include <cls.h>
#include <comparators.h>
#include <stats_context.h>
#include <stats_personality.h>


static void end_func (stats_context_t *ctxt) {
    /* NOP */
}

static void configure_func (stats_context_t *ctxt) {
  ctxt->do_sort = 1;
  ctxt->do_total_row = 0;
  ctxt->resultlist_sizeone = sizeof(jmpthread*);
}

static void calc_pre_func (stats_context_t *ctxt) {
    /* NOP */
}

static void calc_func (void *data, void *arg) {
    jmpthread *c = (jmpthread *)data;
    stats_context_t *ctxt = (stats_context_t *)arg;    

    /* fill in filtered class usage.. */
    if (ctxt->resultlist_offset >= ctxt->resultlist_size) {
        void *nresultlist;
        int nsize;

        nsize = ctxt->resultlist_size + ctxt->resultlist_sizegrow;
        nresultlist = realloc (ctxt->resultlist, nsize * ctxt->resultlist_sizeone);
        /* TODO handle NULL here */
        ctxt->resultlist = nresultlist;
        ctxt->resultlist_size = nsize;
    }
    ctxt->resultlist[ctxt->resultlist_offset++] = c;
}

static void calc_post_func (stats_context_t *ctxt) {
    /* NOP */
}

const struct stats_personality stats_personality_jmpthread_usage = {
  "jmpthread_usage",	/* label */
  end_func,		/* end_func */
  configure_func,	/* configure_func */
  calc_pre_func,	/* calc_pre_func */
  calc_func,		/* calc_func */
  calc_post_func,	/* calc_post_func */
  jmpthread_compr_name,	/* compr_func */
};

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
