/***** BEGIN LICENSE BLOCK *****
 * Version: CPL 1.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Common Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/cpl-v10.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2007 Ola Bini <ola@ologix.com>
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the CPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the CPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jvyamlb;

import java.io.InputStream;
import java.io.OutputStream;

import org.jruby.util.ByteList;

/**
 * @author <a href="mailto:ola.bini@ki.se">Ola Bini</a>
 */
public class DefaultYAMLFactory implements YAMLFactory {
    public Scanner createScanner(final ByteList io) {
        return new ScannerImpl(io);
    }
    public Scanner createScanner(final InputStream io) {
        return new ScannerImpl(io);
    }
    public Parser createParser(final Scanner scanner) {
        return new ParserImpl(scanner);
    }
    public Parser createParser(final Scanner scanner, final YAMLConfig cfg) {
        return new ParserImpl(scanner,cfg);
    }
    public Resolver createResolver() {
        return new ResolverImpl();
    }
    public Composer createComposer(final Parser parser, final Resolver resolver) {
        return new ComposerImpl(parser,resolver);
    }
    public Constructor createConstructor(final Composer composer) {
        return new ConstructorImpl(composer);
    }

    public Emitter createEmitter(final OutputStream output, final YAMLConfig cfg) {
        return new EmitterImpl(output,cfg);
    }
    public Serializer createSerializer(final Emitter emitter, final Resolver resolver, final YAMLConfig cfg) {
        return new SerializerImpl(emitter,resolver,cfg);
    }
    public Representer createRepresenter(final Serializer serializer, final YAMLConfig cfg) {
        return new RepresenterImpl(serializer,cfg);
    }

}// DefaultYAMLFactory
