/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikiwizard.Token;

public class RETokenizer {
    protected Pattern thePattern;
    protected int groups;
    protected Matcher theMatcher;

    public RETokenizer(String regEx, int groups) {
        this.groups = groups;
        this.thePattern = Pattern.compile(regEx, 32);
    }

    public void createTokenizer(String text) {
        this.theMatcher = this.thePattern.matcher(text);
    }

    protected Token getToken(int pos) {
        for (int i = 1; i <= this.groups; ++i) {
            String token = this.theMatcher.group(i);
            if (token == null) continue;
            return new Token(token, pos, i);
        }
        return null;
    }

    public Token nextToken() {
        if (this.theMatcher.find()) {
            return this.getToken(this.theMatcher.start());
        }
        return null;
    }
}

