/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.util.ArrayList;
import java.util.Vector;
import org.wikiwizard.RETokenizer;
import org.wikiwizard.Token;
import org.wikiwizard.WikiTag;

public class TagTokenizer
extends RETokenizer {
    protected Vector tokenVector = new Vector();
    protected static int globalTokenInc = 0;
    public ArrayList tagsCollection;

    public TagTokenizer(String regEx, int groups) {
        super(regEx, groups);
    }

    public void createTokenizer(String text) {
        this.theMatcher = this.thePattern.matcher(text);
        this.addToTokenVector();
        for (int tokenInc = 0; tokenInc < this.tokenVector.size(); ++tokenInc) {
            System.out.println("Token INC: " + tokenInc);
            Token embeddedToken = (Token)this.tokenVector.get(tokenInc);
            if (embeddedToken == null) continue;
            String embeddedText = embeddedToken.getText();
            int tokenGroup = embeddedToken.getGroup();
            try {
                WikiTag theTag = (WikiTag)this.tagsCollection.get(embeddedToken.getGroup() - 1);
                String insideTags = embeddedText.substring(theTag.startTagLength, embeddedText.length() - theTag.endTagLength);
                if (insideTags == null) continue;
                this.theMatcher = this.thePattern.matcher(insideTags);
                this.addToTokenVector();
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception caught - Token Group: " + tokenGroup);
                System.out.println("Embedded text: " + embeddedText);
                e.printStackTrace();
            }
        }
    }

    protected void addToTokenVector() {
        while (this.theMatcher.find()) {
            Token curToken = this.getToken(this.theMatcher.start());
            this.tokenVector.add(curToken);
            System.out.println(curToken.getText());
            System.out.println("-------------------");
        }
    }

    protected Token getToken(int pos) {
        for (int i = 1; i <= this.groups; ++i) {
            String token = this.theMatcher.group(i);
            if (token == null) continue;
            return new Token(token, pos, i);
        }
        return null;
    }

    public Token nextToken() {
        if (globalTokenInc < this.tokenVector.size()) {
            return (Token)this.tokenVector.get(globalTokenInc++);
        }
        return null;
    }
}

