/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.wikiwizard.TagColor;
import org.wikiwizard.WikiTagManager;

public class WikiTag {
    static final int NONEHEADER = 0;
    static final int HEADERSMALL = 1;
    static final int HEADERMEDIUM = 2;
    static final int HEADERLARGE = 3;
    static final int START_AND_END_HIGHLIGHT = 1;
    static final int FIRST_WORD_HIGHLIGHT = 2;
    static final int SOURCE_CODE_HIGHLIGHT = 3;
    static final int START_TAG_HIGHLIGHT = 4;
    static final int HEADER_HIGHLIGHT = 5;
    static final int TABLE_HIGHLIGHT = 6;
    public String startTag;
    public String endTag;
    public int startTagLength;
    public int endTagLength;
    public Color backgroundColor;
    public boolean bold;
    public boolean italic;
    public int tagFontSize;
    public int textFontSize;
    public Color tagColor;
    public Color textColor;
    public SimpleAttributeSet startTagAttributes;
    public SimpleAttributeSet endTagAttributes;
    public SimpleAttributeSet textAttributes;
    public String fontFamily;
    public int headerTag;
    public String regEx;
    public boolean atBeginning;
    public int tagGroup;
    public boolean tagFirstRow;
    public boolean table;
    public int tagNr;
    public String separator;
    public Color separatorColor;
    public SimpleAttributeSet separatorAttributes;
    public Color separateTextColor;
    public SimpleAttributeSet separateTextAttributes;
    public boolean isCode;
    public boolean isCodeRight;
    public SimpleAttributeSet startLineAttributes;

    public WikiTag(WikiTagManager manager, String startTag, String endTag, Color backgroundColor, boolean bold, boolean italic, int tagFontSize, int textFontSize, Color tagColor, Color textColor, String fontFamily, int headerTag, boolean atBeginning, boolean tagFirstRow, boolean table, String separator, Color separatorColor, Color separateTextColor, boolean isCode, boolean isCodeRight, Color startLine) {
        this.startTag = startTag;
        this.endTag = endTag;
        this.startTagLength = startTag.length();
        this.endTagLength = endTag.length();
        this.backgroundColor = backgroundColor;
        this.bold = bold;
        this.italic = italic;
        this.tagFontSize = tagFontSize;
        this.textFontSize = textFontSize;
        this.tagColor = tagColor;
        this.textColor = textColor;
        this.fontFamily = fontFamily;
        this.headerTag = headerTag;
        this.atBeginning = atBeginning;
        this.tagFirstRow = tagFirstRow;
        this.table = table;
        this.separator = separator;
        this.separatorColor = separatorColor;
        this.separateTextColor = separateTextColor;
        this.isCode = isCode;
        this.isCodeRight = isCodeRight;
        manager.addTag(this);
        this.startTagAttributes = new SimpleAttributeSet();
        StyleConstants.setBold(this.startTagAttributes, true);
        StyleConstants.setItalic(this.startTagAttributes, italic);
        StyleConstants.setFontSize(this.startTagAttributes, tagFontSize);
        StyleConstants.setFontFamily(this.startTagAttributes, fontFamily);
        StyleConstants.setForeground(this.startTagAttributes, new TagColor(tagColor.getRed(), tagColor.getGreen(), tagColor.getBlue(), this.tagNr, true, false));
        this.endTagAttributes = new SimpleAttributeSet();
        StyleConstants.setBold(this.endTagAttributes, true);
        StyleConstants.setItalic(this.endTagAttributes, italic);
        StyleConstants.setFontSize(this.endTagAttributes, tagFontSize);
        StyleConstants.setFontFamily(this.endTagAttributes, fontFamily);
        StyleConstants.setForeground(this.endTagAttributes, new TagColor(tagColor.getRed(), tagColor.getGreen(), tagColor.getBlue(), this.tagNr, false, true));
        this.textAttributes = new SimpleAttributeSet();
        StyleConstants.setBold(this.textAttributes, bold);
        StyleConstants.setItalic(this.textAttributes, italic);
        StyleConstants.setFontSize(this.textAttributes, textFontSize);
        StyleConstants.setFontFamily(this.textAttributes, fontFamily);
        StyleConstants.setForeground(this.textAttributes, new TagColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), this.tagNr, false, false));
        if (!separator.equals("")) {
            this.separatorAttributes = new SimpleAttributeSet();
            StyleConstants.setBold(this.separatorAttributes, true);
            StyleConstants.setItalic(this.separatorAttributes, italic);
            StyleConstants.setFontSize(this.separatorAttributes, tagFontSize);
            StyleConstants.setFontFamily(this.separatorAttributes, fontFamily);
            StyleConstants.setForeground(this.separatorAttributes, new TagColor(separatorColor.getRed(), separatorColor.getGreen(), separatorColor.getBlue(), this.tagNr, true, false));
            this.separateTextAttributes = new SimpleAttributeSet();
            this.separateTextAttributes.setResolveParent(this.textAttributes);
            StyleConstants.setForeground(this.separateTextAttributes, new TagColor(separateTextColor.getRed(), separateTextColor.getGreen(), separateTextColor.getBlue(), this.tagNr, true, false));
        }
        this.startLineAttributes = new SimpleAttributeSet();
        StyleConstants.setBold(this.startLineAttributes, true);
        StyleConstants.setItalic(this.startLineAttributes, italic);
        StyleConstants.setFontSize(this.startLineAttributes, tagFontSize);
        StyleConstants.setFontFamily(this.startLineAttributes, fontFamily);
        StyleConstants.setForeground(this.startLineAttributes, new TagColor(startLine.getRed(), startLine.getGreen(), startLine.getBlue(), this.tagNr, false, false));
        this.createRegExTerm();
        this.analyseTagGroup();
    }

    public void analyseTagGroup() {
        if (this.table) {
            this.tagGroup = 6;
        } else if (!(this.startTag.equals("") || this.endTag.equals("") || this.hasBackground())) {
            this.tagGroup = 1;
        } else if (!this.startTag.equals("") && !this.endTag.equals("") && this.hasBackground() && this.tagFirstRow) {
            this.tagGroup = 2;
        } else if (!this.startTag.equals("") && !this.endTag.equals("") && this.hasBackground() && !this.tagFirstRow) {
            this.tagGroup = 3;
        } else if (!this.startTag.equals("") && this.endTag.equals("") && this.headerTag == 0) {
            this.tagGroup = 4;
        } else if (!this.startTag.equals("") && this.endTag.equals("") && this.headerTag != 0) {
            this.tagGroup = 5;
        }
    }

    public boolean hasBackground() {
        return this.backgroundColor.getRed() != 0 || this.backgroundColor.getGreen() != 0 || this.backgroundColor.getBlue() != 0;
    }

    private void createRegExTerm() {
        int i;
        String startTag = "";
        String endTag = "";
        for (i = 0; i < this.startTag.length(); ++i) {
            if (!Character.isLetterOrDigit(this.startTag.charAt(i))) {
                startTag = startTag + "\\";
            }
            startTag = startTag + this.startTag.substring(i, i + 1);
        }
        for (i = 0; i < this.endTag.length(); ++i) {
            endTag = endTag + "\\" + this.endTag.substring(i, i + 1);
        }
        if (this.headerTag != 0 || endTag.equals("") && this.atBeginning) {
            this.regEx = "(^" + startTag + "|\n" + startTag + ")";
        } else if (endTag.equals("") && !this.atBeginning) {
            this.regEx = "(" + startTag + ")";
        } else if (!startTag.equals("") && !endTag.equals("")) {
            this.regEx = "(" + startTag + ".*?" + endTag + ")";
        }
    }

    public String getStartTag() {
        return this.startTag;
    }

    public String getEndTag() {
        return this.endTag;
    }

    public String getFontFamily() {
        return null;
    }
}

