<%@ taglib uri="/WEB-INF/jspwiki.tld" prefix="wiki" %>
<%@ page import="java.security.Principal" %>
<%@ page import="org.apache.log4j.*" %>
<%@ page import="com.ecyrd.jspwiki.*" %>
<%@ page import="com.ecyrd.jspwiki.auth.*" %>
<%@ page errorPage="/Error.jsp" %>
<%! 
  public void jspInit()
  {
    wiki = WikiEngine.getInstance( getServletConfig() );
  }
  Logger log = Logger.getLogger("JSPWiki"); 
  WikiEngine wiki;
  SecurityVerifier verifier;
%>
<%
  WikiContext wikiContext = wiki.createContext( request, WikiContext.NONE );
  if(!wikiContext.hasAccess( response )) return;
  response.setContentType("text/html; charset="+wiki.getContentEncoding() );
  verifier = new SecurityVerifier( wiki, wikiContext.getWikiSession() );
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>JSPWiki Security Configuration Verifier</title>
  <base href="../"/>
  <link rel="stylesheet" media="screen, projection" type="text/css" href="<wiki:Link format="url" templatefile="jspwiki.css"/>"/>
  <wiki:IncludeResources type="stylesheet"/>
</head>
<body class="view">
<div id="wikibody">
<div id="page">
<div id="pagecontent">

<h1>JSPWiki Security Configuration Verifier</h1>

<p>This page examines JSPWiki's security configuration and tries to determine if it is working the way it should. Although JSPWiki comes configured with some reasonable default configuration settings out of the box, it's not always obvious what settings to change if you need to customize the security... and sooner or later, just about everyone does.</p>

<p>This page is dynamically generated by JSPWiki. It examines the authentication, authorization and security policy settings. When we think something looks funny, we'll try to communicate what the issue might be, and will make recommendations on how to fix the problem.</p>

<p><strong>Please delete this JSP when you are finished troubleshooting your system. 
This diagnostic data presented on this page do not represent a security risk
to your system <em>per se</em>, but they do provide a significant amount of
contextual information that could be useful to an attacker. This page is
unconstrained, which means that anyone can view it: nice people, mean people
and everyone in between. You have been warned.</strong></p>

<!-- 
  *********************************************
  **** A U T H E N T I C A T I O N         ****
  *********************************************
-->
<h2>Authentication Configuration</h2>
<!-- 
  *********************************************
  **** Container Authentication Verifier   ****
  *********************************************
-->
<h3>Container-Managed Authentication</h3>
<%
  boolean isContainerAuth = wiki.getAuthenticationManager().isContainerAuthenticated();
  AuthorizationManager authorizationManager = wiki.getAuthorizationManager();
  if ( isContainerAuth )
  {
%>
    <!-- We are using container auth -->
    <p>I see that you've configured container-managed authentication. Very nice.</p>
<%
  }
  else
  {
%>
    <!-- We are not using container auth -->
    <p>Container-managed authentication appears to be disabled, according to your <code>WEB-INF/web.xml</code> file.</p>
<%
  }
%>

    
<!-- 
  *********************************************
  **** JAAS Authentication Config Verifier ****
  *********************************************
-->
<h3>JAAS Login Configuration</h3>

<!-- Notify users which JAAS configs we need to find -->
<p>JSPWiki uses JAAS to define the authentication process. We need to be able to locate a JAAS configuration file. The default location is <code>WEB-INF/jspwiki.jaas</code>), and its location is specified by the <code>java.security.auth.login.config</code> system property.</p>

<wiki:Messages div="information" topic="<%=SecurityVerifier.INFO+"java.security.auth.login.config"%>" prefix="Good news: "/>
<wiki:Messages div="warning" topic="<%=SecurityVerifier.WARNING+"java.security.auth.login.config"%>" prefix="We found some potential problems with your configuration: "/>
<wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR+"java.security.auth.login.config"%>" prefix="We found some errors with your configuration: " />

<!-- Let the admin know if something other than JSPWiki set the config property first -->
<%
  if ( verifier.isJaasConfiguredAtStartup() )
  {
%>
    <div class="warning">Note: some other application set the JAAS <code>java.security.auth.login.config</code> system property before JSPWiki started up. It could have been done by a prior installation of JSPWiki, or possibly by your web container's startup script. This is not necessary a bad thing, but we thought you should be aware of it in case you are seeing behavior you don't expect. You can ignore this message if we find the JAAS login configurations (below).</div>
<%
  }
  else
  {
%>
    <div class="information">Note: this instance of JSPWiki set the system property at startup.</div>
<%
  }
%>

<!-- Print JAAS configuration status -->
<p>Inside the JAAS config file, we must be able to find two login configurations: <code>JSPWiki-container</code> and <code>JSPWiki-custom</code>.</p>

<wiki:Messages div="information" topic="<%=SecurityVerifier.INFO_JAAS%>" prefix="Good news: "/>
<wiki:Messages div="warning" topic="<%=SecurityVerifier.WARNING_JAAS%>" prefix="We found some potential problems with your configuration: "/>
<wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR_JAAS%>" prefix="We found some errors with your configuration: " />
<%
  if ( !verifier.isJaasConfigured() )
  {
%>
    <div class="error">The JAAS configuration looks broken. Users may not be able to log in. You should be able to fix this by locating the JAAS configuration file and appending the contents of <code>WEB-INF/jspwiki.jaas</code>.</div>
<%
  }
%>

<!-- 
  *********************************************
  **** A U T H O R I Z A T I O N           ****
  *********************************************
-->
<h2>Authorization Configuration</h2>

<!-- 
  *********************************************
  **** Container Authorization Verifier    ****
  *********************************************
-->
<h3>Container-Managed Authorization</h3>
<%
  if ( isContainerAuth )
  {
%>
    <!-- We are using container auth -->
    <p>I see that you've configured container-managed authorization. Very nice.</p>
<%
    Principal[] roles = verifier.webContainerRoles();
    if ( roles.length > 0 )
    {
%>
      <!-- Even better, we are using the standard authorizer, which
           allows us to identify the roles the container knows about -->
      <p>Your <code>WEB-INF/web.xml</code> file defines the following roles:</p>
      <ul>
<%
        for( int i = 0; i < roles.length; i++ )
        {
%>
          <li><%=roles[i].getName()%></li>
<%
        }
%>
      </ul>
<%
    }
    else
    {
%>
      <!-- No roles! That's very odd -->
      <div class="error">Your <code>WEB-INF/web.xml</code> file does not define any roles. This is an error.</div>
<%
    }
  }
  else
  {
%>
    <!-- We are not using container auth -->
    <p>Container-managed authorization appears to be disabled, according to your <code>WEB-INF/web.xml</code> file.</p>
<%
  }
%>

<!-- 
  *********************************************
  **** Java Security Policy Verifier       ****
  *********************************************
-->
<h3>Security Policy</h3>
<p>JSPWiki's authorizes user actions by consulting a standard Java 2 security policy file. By default, JSPWiki installs its local security policy file at startup time. This policy file is independent of your global, JVM-wide security policy, if you have one. When checking for authorization, JSPWiki consults the global policy first, then the local policy.</p>

<p>Let's validate the local security policy file. To do this, we parse
the security policy and examine each <code>grant</code> block. If we see
a <code>permission</code> entry that is signed, we verify that the certificate
alias exists in our keystore. The keystore itself must also exist in the file system.
And as an additional check, we will try to load each <code>Permission</code> class into memory to verify that JSPWiki's classloader can find them.</p>

<wiki:Messages div="information" topic="<%=SecurityVerifier.INFO_POLICY%>" prefix="Good news: "/>
<wiki:Messages div="warning" topic="<%=SecurityVerifier.WARNING_POLICY%>" prefix="We found some potential problems with your configuration: "/>
<wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR_POLICY%>" prefix="We found some errors with your configuration: " />

<%
  if ( !verifier.isSecurityPolicyConfigured() )
  {
%>
    <p>Note: JSPWiki's Policy file parser is stricter than the default parser that ships with the JVM. If you encounter parsing errors, make sure you have the correct comma and semicolon delimiters in your policy file <code>grant</code> entries. The <code>grant</code> blocks must follow this format:</p>
    <blockquote>
      <pre>grant signedBy "signer_names", codeBase "URL",
    principal principal_class_name "principal_name",
    principal principal_class_name "principal_name",
    ... {
    
    permission permission_class_name "target_name", "action";
    permission permission_class_name "target_name", "action";
};</pre>
    </blockquote>

    <p>Note: JSPWiki versions prior to 2.4.6 accidentally omitted commas after the <code>signedBy</code> entries, so you should fix this if you are using a policy file based on a version earlier than 2.4.6.</p>
<%
  }
%>

<h2>Access Control Validation</h2>

<h3>Security Policy Restrictions</h3>

<p>Now comes the <em>really</em> fun part. Using the current security policy, we will test the PagePermissions each JSPWiki role possesses for a range of pages. The roles we will test include the standard JSPWiki roles (Authenticated, All, etc.) plus any others you may have listed in the security policy. In addition to the PagePermissions, we will also test the WikiPermissions. The results of these tests should tell you what behaviors you can expect based on your security policy file. If we had problems finding, parsing or verifying the policy file, these tests will likely fail.</p>

<p>The colors in each cell show the results of the test. <font style="background-color: #c0ffc0;">&nbsp;Green&nbsp;</font> means success; <font style="background-color: #ffc0c0;">&nbsp;red&nbsp;</font> means failure. Hovering over a role name or individual cell will display more detailed information about the role or test.</p>

<%=verifier.policyRoleTable()%>

<div class="information">Important: these tests do not take into account any page-level access control lists. Page ACLs, if they exist, will contrain access further than what is shown in the table.
<%
  if ( isContainerAuth )
  {
%>
In addition, because you are using container-managed security, constraints on user activities might be stricter than what is shown in this table. If the container requires that users accessing <code>Edit.jsp</code> possess the container role "Admin," for example, this will override an "edit" PagePermission granted to role "Authenticated." See below.
<%
  }
%>
</div>

<%
  if ( isContainerAuth )
  {
%>
    <h3>Web Container Restrictions</h3>

    <p>Here is how your web container will control role-based access to some common JSPWiki actions and their assocated JSPs. These restrictions will be enforced even if your Java security policy is more permissive.</p>

    <p>The colors in each cell show the results of the test. <font style="background-color: #c0ffc0;">&nbsp;Green&nbsp;</font> means success; <font style="background-color: #ffc0c0;">&nbsp;red&nbsp;</font> means failure.</p>

    <!-- Print table showing role restrictions by JSP -->
    <%=verifier.containerRoleTable()%>

    <div class="information">Important: these tests do not take into account any page-level access control lists. Page ACLs, if they exist, will contrain access further than what is shown in the table.</div>

    <!-- Remind the admin their container needs to return the roles -->
    <p>Note that your web container will allow access to these pages <em>only</em> if your container's authentication realm returns the roles
<%
    Principal[] roles = verifier.webContainerRoles();
    for( int i = 0; i < roles.length; i++ )
    {
%>&nbsp;<strong><%=(roles[i].getName() + (i<(roles.length-1)?",":""))%></strong><%
    }
%>
    If your container's realm returns other role names, users won't be able to access the pages they should be allowed to see -- because the role names don't match. In that case, You should adjust the <code>&lt;role-name&gt;</code> entries in <code>web.xml</code> appropriately to match the role names returned by your container's authorization realm.</p>
    
    <p>Now we are going to compare the roles listed in your security policy with those from your <code>web.xml</code> file. The ones we care about are those that aren't built-in roles like "All", "Anonymous", "Authenticated" or "Asserted". If your policy shows roles other than these, we need to make sure your container knows about them, too. Container roles are defined in <code>web.xml</code> in blocks such as these:</p>
    <blockquote><pre>&lt;security-role&gt;
  &lt;description&gt;
    This logical role includes all administrative users
  &lt;/description&gt;
  &lt;role-name&gt;Admin&lt;/role-name&gt;
&lt;/security-role&gt;</pre></blockquote>

    <wiki:Messages div="information" topic="<%=SecurityVerifier.INFO_ROLES%>" prefix="Good news: "/>
    <wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR_ROLES%>" prefix="We found some errors with your configuration: " />

<%
  }
%>

<h2>User and Group Databases</h2>

<h3>User Database Configuration</h3>
<p>The user database stores user profiles. It's pretty important that it functions properly. We will try to determine what your current UserDatabase implementation is, based on the current value of the <code>jspwiki.userdatabase</code> property in your <code>jspwiki.properties</code> file. In addition, once we establish that the UserDatabase has been initialized properly, we will try to add (then, delete) a random test user. If all of these things work they way they should, then you should have no problems with user self-registration.</p>

<wiki:Messages div="information" topic="<%=SecurityVerifier.INFO_DB%>" prefix="Good news: "/>
<wiki:Messages div="warning" topic="<%=SecurityVerifier.WARNING_DB%>" prefix="We found some potential problems with your configuration: "/>
<wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR_DB%>" prefix="We found some errors with your configuration: " />

<h3>Group Database Configuration</h3>
<p>The group database stores wiki groups. It's pretty important that it functions properly. We will try to determine what your current GroupDatabase implementation is, based on the current value of the <code>jspwiki.groupdatabase</code> property in your <code>jspwiki.properties</code> file. In addition, once we establish that the GroupDatabase has been initialized properly, we will try to add (then, delete) a random test group. If all of these things work they way they should, then you should have no problems with wiki group creation and editing.</p>

<wiki:Messages div="information" topic="<%=SecurityVerifier.INFO_GROUPS%>" prefix="Good news: "/>
<wiki:Messages div="warning" topic="<%=SecurityVerifier.WARNING_GROUPS%>" prefix="We found some potential problems with your configuration: "/>
<wiki:Messages div="error" topic="<%=SecurityVerifier.ERROR_GROUPS%>" prefix="We found some errors with your configuration: " />

<!-- We're done... -->
</div>
</div>
</div>
</body>
</html>
