// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "uuid.h"

#include <iomanip>
#include <iostream>

namespace k3d
{

std::ostream& operator<<(std::ostream& Stream, const k3d::uuid& Value)
{
	std::ostream::fmtflags oldflags(Stream.flags());
	Stream.setf(std::ostream::right);

	const char oldfill(Stream.fill());
	Stream.fill('0');

	Stream << std::hex << std::setw(8) << Value.data1 << " " << std::setw(8) << Value.data2 << " " << std::setw(8) << Value.data3 << " " << std::setw(8) << Value.data4;

	Stream.fill(oldfill);
	Stream.flags(oldflags);

	return Stream;
}

std::istream& operator>>(std::istream& Stream, k3d::uuid& Value)
{
	std::istream::fmtflags oldflags(Stream.flags());

	Stream >> std::hex >> Value.data1 >> Value.data2 >> Value.data3 >> Value.data4;

	Stream.flags(oldflags);

	return Stream;
}

} // namespace
