#ifndef __KADU_FIREWALL_H
#define __KADU_FIREWALL_H

#include <qobject.h>
#include <qdatetime.h>
#include <qregexp.h>

#include "configuration_aware_object.h"
#include "gadu.h"
#include "main_configuration_window.h"
class ChatWidget;
class QListBox;

class Firewall : public ConfigurationUiHandler, ConfigurationAwareObject
{
	Q_OBJECT

	public:
		Firewall();
		virtual ~Firewall();
		virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);
		
	private:
		QStringList secured, secured_temp_allowed;
		QString last_uin;	//TODO: pozby si tego
		UserListElements passed;
		unsigned int flood_messages;
		QTime lastMsg;
		QTime lastNotify;
		bool right_after_connection;
		QRegExp pattern;
		QListBox* allList;
		QListBox* secureList;
		QTextEdit *questionEdit;
		QLineEdit *answerEdit;

		void loadSecuredList(void);
		void saveSecuredList(void);
		bool isSecured(const QString &id);
		
		bool checkChat(const QString &message, const UserListElements senders, const QString &user, bool &stop);
		bool checkConference(const QString &message, const UserListElements senders, const QString &user);
		bool checkEmoticons(const QString &message);
		bool checkFlood();
		
		void showHint(const QString &u, const QString &m);
		void writeLog(const QString &u, const QString &m);

		void defaultSettings();
		
	private slots:
		void messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop);
		void chatDestroyed(ChatWidget *);
		void sendMessageFilter(const UserListElements users, QString &msg, bool &stop);

		void userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool);
		void userAdded(UserListElement, bool, bool);
		void userRemoved(UserListElement, bool, bool);
		
		void connected();
		void connecting();
		void changeRight_after_connection();
		
		void _Left();
		void _Right();

	protected:
		virtual void configurationUpdated();
};

#endif
