#ifndef SCREENSHOT_H
#define SCREENSHOT_H

#include <qmap.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qwidget.h>

#include <X11/extensions/shape.h>
#include <vector>

class QMouseEvent;
class QKeyEvent;
class QPaintEvent;
class Chat;
class ChatButton;
class UserGroup;
class QTimer;
class QLabel;
class ConfigFile;
class QPopupMenu;
class QPixmap;

enum ScreenShotMode
{
	STANDARD = 0,
	WITH_CHAT_MINIMIZED = 1,
	SINGLE_WINDOW = 2
};

class ShotSizeHint : public QWidget
{
	friend class ScreenShot;

	QLabel *geom;
	QLabel *fileSize;

public:
	ShotSizeHint();

};

class Action;
class ChatWidget;
class ConfigurationUiHandler;
class ScreenShotConfigurationUiHandler;

class ScreenShot : public QWidget
{
	Q_OBJECT

	ConfigurationUiHandler *UiHandler;
	Action *screenshot_action;
	bool buttonPressed;
	QRect region;
	QMap<ChatWidget *, ChatButton *> chatButtons;
	ChatWidget *tempChat;
	QPixmap pixmap;
	ShotSizeHint *sizeHint;
	QTimer *hintTimer;
	QPopupMenu* menu;
	int popups[3];
	ScreenShotMode shotType;
	bool wasMaximized;
	bool warnedAboutSize;
	int minSize;

	void drawRegionRect();
	void checkShotsSize();
	void takeWindowShot();
	void handleShot(QPixmap p);

	// TABS module fixing methods
	void minimize(QWidget *w);
	void restore(QWidget *w);
	bool isMaximized(QWidget *w);

	// Methods from KSnapShot
	QPixmap grabCurrent();
	Window findRealWindow( Window w, int depth = 0 );
	void getWindowsRecursive( std::vector<QRect>& windows, Window w, int rx = 0, int ry = 0, int depth = 0 );
	QPixmap grabWindow( Window child, int x, int y, uint w, uint h, uint border );
	Window windowUnderCursor();

	void createDefaultConfiguration();

private slots:
	void updateHint();
	void takeShot_Step2();
	void takeWindowShot_Step2();
	void takeShot(int ident);
	void grabMouseSlot();
	void screenshotActionActivated(const UserGroup *grp, const QWidget *source);

public:
	ScreenShot(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~ScreenShot();

	ConfigurationUiHandler * configurationUiHandler() { return UiHandler; }

	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void keyPressEvent(QKeyEvent *e);

};

extern ScreenShot* screenShot;

#endif
