/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "show_forecast_dialog.h"
#include "citysearchresult.h"
#include "getcitydialog.h"
#include "showforecastframe.h"
#include "textprogress.h"
#include "weather_global.h"

#include <qlayout.h>
#include <qtabwidget.h>

ShowForecastDialog::ShowForecastDialog( const CitySearchResult& city, UserListElement user )
	: user_( user )
{
	setWFlags( getWFlags() | Qt::WDestructiveClose );
	
	ShowForecastFrameBase* page = new ShowForecastFrame( this, city );
	connect( page, SIGNAL(changeCity()), this, SLOT(changeCity()) );
	
	QTabWidget* tabs = new QTabWidget( this );
	tabs->addTab( page, weather_global->getServerName( city.server_ ) );
	connect( tabs, SIGNAL(currentChanged( QWidget* )), this, SLOT(tabChanged( QWidget* )) );
	
	QVBoxLayout* layout = new QVBoxLayout( this );
	layout->addWidget( tabs );
	
	WeatherGlobal::SERVERITERATOR serverIt = weather_global->beginServer();
	while( serverIt != weather_global->endServer() )
	{
		if( (*serverIt).configFile_ != city.server_ )
		{
			ShowForecastFrameBase* newpage = new SearchAndShowForecastFrame(this, city.cityName_, (*serverIt).configFile_);
			tabs->addTab( newpage, (*serverIt).name_ );
			connect( newpage, SIGNAL(changeCity()), this, SLOT(changeCity()) );
		}
		serverIt = weather_global->nextServer( serverIt );
	}
	
	setCaption(  tr("%1 - Forecast").arg( city.cityName_)  );
}

void ShowForecastDialog::tabChanged( QWidget* page )
{
	ShowForecastFrameBase* frame = reinterpret_cast<ShowForecastFrameBase*>( page );
	frame->start();
}

void ShowForecastDialog::changeCity()
{
	close();
	SearchingCityDialog* scd = new SearchingCityDialog( user_ );
	scd->show();
}
