/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef THUMBSSOURCEPAGE_H
#define THUMBSSOURCEPAGE_H

#include "kthumbsourcepage.h"
#include "wizardpagebase.h"

/**
 * @short
 * Thumbnail selection page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class ThumbsSourcePage: public KThumbSourcePage, public WizardPageBase  {
Q_OBJECT
public:
  ThumbsSourcePage(QWidget *parent = 0, const char *name = 0);

  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
  /**
   * Load thumbnails from the disk.
   */
  void slotLoadThumbnails();
  /**
   * Remove thumbnails from the list.
   */
  void slotRemoveThumbnail();
};

#endif
