/***************************************************************************
    copyright            : (C) 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WIZARDPAGEBASE_H
#define WIZARDPAGEBASE_H

/**
 * @short
 * Base class for all wizard pages. Provides pure virtual methods which must be
 * reimplemented.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
*/
class WizardPageBase{
public:
  /**
    * Called when Help was pressed by the user.
    */  
  virtual void invokeHelp() = 0;
  
  /** 
    * Reads the settings from the page. 
    * @return true if everything's ok, and the user can go to the next page, 
    *         otherwise returns false. 
    */  
  virtual bool processPage() = 0;
  
  /** 
   * Setup this page, because the user will see it just in a moment. 
   */
  virtual void setupPage() = 0;
};

#endif
