/*
    collectionviewer.h - Show items from collection.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef COLLECTIONVIEWER_H
#define COLLECTIONVIEWER_H

#include <qwidget.h>
#include <rommetainformation.h>
#include <kurl.h>

class QListViewItem;
/**
 * Show items from the collection in a KListView. Also add a filter bar.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
 */
class CollectionViewer : public QWidget
{
	Q_OBJECT
public:
    CollectionViewer(QWidget *parent = 0, const char *name = 0);
    ~CollectionViewer();

	/**
	 * Return the collection size.
	 */
	int collectionSize() const;

public slots:
	/**
	 * Clear the collection viewer.
	 */
	void clear();

	void addItem(const Kamefu::RomMetaInformation &romMetaInfo);
	
	/**
	 * Update selected rom item in list view after being edited.
	 * @param romUrl URL is used to identity the rom.
	 */
	void updateSelectedRomInformation(const QString &romUrl);

	/**
	 * Update selected rom items in list view after being edited.
	 */
	void updateSelectedRoms();

	/**
	 * @brief Remove selected QListViewItem.
	 * Used to remove deleted/trashed item from CollectionListView.
	 * Only call this when you have selected items.
	 */
	void removeSelectedItems();

signals:
	void itemExecuted(const QString &url);
	void itemSelected(const QString &url);
	/**
	 * Dispatch editRoms to KamefuView.
	 */
	void itemEditMetadata(const KURL::List &romList);
	/**
	 * Dispatch deleteRoms call to KamefuView.
	 */
	void itemDeleteRoms(const KURL::List &romList);
	/**
	 * Dispatch trashRoms call to KamefuView.
	 */
	void itemTrashRoms(const KURL::List &romList);

private slots:
	void collectionListExecuted(const QString &url);
	void collectionListSelected(const QString &url);

private:
	class Private;
	Private *d;	
};

#endif
