/***************************************************************************
                          cgz.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CGZ_H
#define CGZ_H

#include <carchive.h>

/**This class will manage the pure .gz archives
  *@author Eric Coquelle
  */

class CGz : public CArchive  {
Q_OBJECT
public: 
	CGz();
	~CGz();
  /** this method will launch the right compressor
		* to list the file contents
		* It will then launch the right method to display
		* the content in the listview */
  void displayArchiveContent();
	/** Upon the kind of archive, choose the right
		* uncompressor and extract all or some files
		* @toutextraire = 9: extract to karchiveur's temp directory (for viewing)
		* @toutextraire = 1: extract all selected files
	*/
	void extractArchive(QString & extractpath, int extractall, QString &filetoextract);
 /** Create a gzip archive
     @param  nameofarchive: the name of the pure .tar archive
     @param param: list of files to add
     @param relativepath: include only filenames, without their path */
 void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath);

protected slots:
	/** we recive some informations through the standard
		output of the process */
	void haveSdtOutExtract(KProcess *prpc, char *buffer, int length);
	/** The current process ended */
	void endProcess(KProcess*);

protected:
	FILE* fileIO;
};

#endif
