/***************************************************************************
                          cled.h  -  description
                             -------------------
    begin                : Sun Jun 18 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLED_H
#define CLED_H

#include <kled.h>

#include <qcolor.h>
#include <qtimer.h>

/**This class is derived from KLed and provides more useful tool
like a temporary warning signal whth orange leds...
  *@author Eric Coquelle
  */

class CLed : public KLed  {
Q_OBJECT
public:
	CLed(QWidget *parent, const char *name);
	CLed(const QColor& ledcolor, QWidget *parent, const char *name);
	CLed(const QColor& ledcolor, KLed::State state, KLed::Look look, KLed::Shape shape, QWidget *parent, const char *name );
	~CLed();
  /** set the led color to color */
  void setColor(const QColor& color);
	
	
private:
	/* A little timer for swapping led color */
	QTimer tempo;
	
public slots: // Public slots
  /** After x seconds, the led will fall back to green */
  void slotTimeOut();
};

#endif
