/***************************************************************************
                          cpreferences.h  -  description
                             -------------------
    begin                : Sat Jul 1 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPREFERENCES_H
#define CPREFERENCES_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlistbox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qfont.h>
#include <qvbox.h>

#include <kfontdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <kdialogbase.h>
#include <kled.h>
#include <kurllabel.h>

/** This class will provide a pretty dialog box in whioch
	* the user can set all the options of karchiveur
  *@author Eric Coquelle
  */

class CPreferences : public KDialogBase  {
   Q_OBJECT
public: 
	CPreferences(QWidget *parent=0, const char *name=0);
	~CPreferences();
  /** return true if we will include the absoute path
		* and not the relative when dropping */
  bool getWholePath();
  /** returns true if we will use an absolute path
		* for files added to the archive */
  bool getCheminAbsolu();
  /** return the compress rate for gzip ans bzip2
		* 0 = min, 9 = max */
  int getCompressLevel();
  /** return true if we will recurse folders when dropping */
  bool getRecursif();
  /** return 0 if we'll display small icons, 1 for medium,
		* 2 for large */
  int getSizeofIconListe();
  /** return 0 for last dir, 1 for home dir, 2 for shell's one
		* ==>set the default directory when OPENING files */
  int getKindofOpeningDirectory();
  /** return 0 if we'll open the last dir, 1 for home dir,
		* and 2 for shell's one */
  int getKindofExtractionDirectory();
  /** return true if we'll read archive using streams,
		* false if we'll read using signal/slot mechanism */
  int getLitParFlot();
  /** return true if files will be overwritten when
	* they are extracted */
  bool getOverwriteWhenExtracting();
  /** return the font for the listview */
  QFont getFont();
  /** set the widgets for the date displayed on the
		* listview */
  void setDateOptions();
  /** return the kind of date that will be displayed in
		* the listview:
		* 0: standard one (compressor's one)
		* 1: localised 1/1/2000
		* 2: localised: Saturday May 2000 */
  int getKindOfDate();
  /** return true if we'll display the tip of the day
		* at startup */
  bool getDisplayTipofDay();
  /** return 0 if we're in standard Multi selection mode
		1 for extended selection mode
		(i.e. ctrl+click to select) */
  int getSelectionMode();
  /* return true if one whises to get an alternate background */
  bool getAlternateBackground();
  /* return true if one whises to list archive content dir. by dir. */
  bool getReadByDirs();
  /*Returns the extension of the prefered archive type*/
  QString getPreferedArchiveType();
  /* return true if one whises to always add dropped files */
  bool getDefaultDropBehaviour()  ;
  
protected: 
	void initDialog();
  /*Read the config file and set the propper values for all widgets*/
	void readOptions();
	/*Save those options*/
	void Sauver();
  /** verify the avaible compressors */
  void compresseursDispo();
  /** set the widgets for the TAR tab */
  void setTarOptions();
  /** set the widgets for default directories */
  void setDirectoriesOptions();
  /** set the widgets for Icon size options tab */
  void setIconSizeOptions();
  /** set the widgets for reading archive options */
  void setArchiveReadingOptions();
  /** set the widgets for avaible compressors */
  /** allow user to select a font for the listview */
  void setFontOptions();
  void setCompressorsOptions();
  /** set the widgets for the TipofDay tab */
  void setTipofDayOptions();
  /** set misc options for karchiveur */
  void setMiscOptions();
  /*Set the default archive type, when creating archives*/
  void setPreferedArchiveType();
	
protected slots: // Protected slots
  /** close the dialog box, and forget the changes */
  void slotAnnuler();
  /** Save the changes */
  void slotSauver();
  /** close the dialog box and use the changes */
  void slotOk();
  /** set all widgets to default settings */
  void slotDefault();
  /**Display a warning message when the Overwrite checkbox is actavated */
  void slotDisplayWarningOverwrite();
  void processMyURL(const QString&);

private:
	QGroupBox *gbOptionsGzipBzip2;
	QLabel *QLabel_2;
	QComboBox *cmbOGZTauxCompression;
	QLabel *QLabel_3;
	QLabel *QLabel_4m;
	QCheckBox *cbOGZEcrase;
	QGroupBox *gbOptionsTar;
	QCheckBox *cbOTAbsolutePath;
	QCheckBox *cbOTWholePath;
	QCheckBox *cbOTRecursif;
	QGroupBox *gbVisualisateur;
	QGroupBox *gbDirectories;
	QButtonGroup *gbDDExtraction;
	QRadioButton *rbDDEDDernier;
	QRadioButton *rbDDEDMaison;
	QRadioButton *rbDDEDShell;
	QButtonGroup *gbDDOuverture;
	QRadioButton *rbDDODDernier;
	QRadioButton *rbDDODMaison;
	QRadioButton *rbDDODShell;
	QGroupBox *gbTailleIcones;
	QButtonGroup *gbISFichiers;
	QRadioButton *rbISFPetit;
	QRadioButton *rbISFMoyen;
	QRadioButton *rbISFGrand;
	QPushButton *bOk;
	QPushButton *bSauver;
	QPushButton *bAnnuler;
	QButtonGroup *bgLectureArchive;
	QRadioButton *rbOLVeryFast;
	QRadioButton *rbOLRapide;
	QRadioButton *rbOLLent;
	QGroupBox *gbCompresseursDispo;
	KLed *lZipDispo;
	QLabel *QLabel_17;
	QLabel *QLabel_5;
	KLed *lTarDispo;
	QLabel *QLabel_7;
	QLabel *QLabel_8;
	QLabel *QLabel_9;
	QLabel *QLabel_un9;
	QLabel *QLabel_10;
	KLed *lGzipDispo;
	KLed *lLhaDispo;
	KLed *lRarDispo;
	KLed *lUnRarDispo;
	KLed *lBzip2Dispo;
	QLabel *QLabel_15;
	KLed *lUnzipDispo;
	QLabel *QLbl_16;
	KLed *lUnarjDispo;
    KLed *l7zDispo;   
    KLed *lArDispo;
    KLed *lSitDispo;
	QListBox *lbCategorie;
  QCheckBox *cbAlternateBackground;
  QCheckBox *cbDefaultDropBehaviour;
  QCheckBox *cbReadByDir;
  QButtonGroup* bgPreferedCompressor;
  QRadioButton* radiotar;
  QRadioButton* radiotargz;
  QRadioButton* radiotarbz2;
  QRadioButton* radiorar;
  QRadioButton* radiolha;
  QRadioButton* radiozip;
  QRadioButton* radiogz;
  QRadioButton* radiobz2;
  QRadioButton* radioarj;
  QRadioButton* radio7z;
  QRadioButton* radiosit;
  QRadioButton* radiohqx;
	
	/*contains the selected font for the listview*/
	KFontChooser* mFont;
	/* some widgets for the date settings*/
	QButtonGroup *bgDateDisplay;
	QRadioButton *rbDDStandard;
	QRadioButton *rbDDLocalisedSmall;
	QRadioButton *rbDDLocalisedLarge;
	QButtonGroup *gbMOSelectionMode;
	QRadioButton *rbMOSMMulti;
	QRadioButton *rbMOSMExtended;	
 /* Some widgets for the Tips panel*/	
 QCheckBox *cbOTDDisplayTipofDay;
 QRadioButton* rbLFASAlwaysAsk;
 QRadioButton* rbLFASAlwaysYes;
 QRadioButton* rbLFASAlwaysNo;

};

#endif
