import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.text.*;
import java.net.*;

public class ExtractZip extends TimerTask
{
  private Enumeration entries;
  private int size;
  private int counterzipentries;
  private Timer timer;
  private FileOutputStream writeStream = null;
  private InputStream readStream = null;
  private ZipFile currentZipArchive = null;
  private boolean alwaysoverwrite;
  private File extractdirectory;
  private byte[] buffer = new byte[1024];
  private int nbextractedfiles;
  private String zipfilename;
  private JFrame frameparentwindow;
  private ProgressMonitor progressbar = null;
  private ResourceBundle i18nmessages;

  public ExtractZip(ResourceBundle messages)
  {
    i18nmessages=messages;
  }
  
  private String getLocalizedDate(Date d)
  {
  	SimpleDateFormat localizeddate = new SimpleDateFormat("MM/dd/yyyy hh:mma",Locale.getDefault());
	return localizeddate.format(d);
  }

  public void extract(String zipfile, File extrdir, JFrame myframeclass)
  {
      extractdirectory=extrdir;
      zipfilename=zipfile;
      frameparentwindow=myframeclass;
      alwaysoverwrite = false;
     
      try
      {
        currentZipArchive = new ZipFile( new File(zipfile) );
    
        size = currentZipArchive.size();
        int extracted = 0;
        entries = currentZipArchive.entries();
        counterzipentries=0;
        nbextractedfiles=0;
        timer=new Timer();
        timer.scheduleAtFixedRate(this, 0, 1);
        
        progressbar = new ProgressMonitor(frameparentwindow, i18nmessages.getString("Extracting_files"), i18nmessages.getString("Preparing"), 0, size);
        progressbar.setMillisToPopup(0);
    
    
      }
      catch (Exception e)
      {
          System.out.println(e);
          if(currentZipArchive!=null) { try { currentZipArchive.close(); } catch(IOException ioe) {} }
      }
  }
  
  public void run()
  {
      String compresseditem;
      int nbBytesRead;
      
      ZipEntry entry = (ZipEntry) entries.nextElement();
      if(entry.isDirectory())
      {
        counterzipentries++;
        return;
      }
  
      compresseditem= entry.getName();
      if(compresseditem.startsWith("Data/"))
      {
        compresseditem=compresseditem.substring(5);
      }
      else
      {
              counterzipentries++;
              return;
      }
  
     progressbar.setProgress(counterzipentries);
     progressbar.setNote(compresseditem);
     if(progressbar.isCanceled())
     {
       timer.cancel();
       return;
     }
  try
  {
      readStream = currentZipArchive.getInputStream(entry);
  
      File extractedfile = new File(extractdirectory, compresseditem);
      Date dateCompressedFile = new Date(entry.getTime());
      if( (alwaysoverwrite==false) && extractedfile.exists() )
      {
          Object[] options = {i18nmessages.getString("Yes"), i18nmessages.getString("Yes_to_all"), i18nmessages.getString("No")};
          
          int overwrite = JOptionPane.showOptionDialog(frameparentwindow,
              i18nmessages.getString("Warning_shall_I_overwrite")
                  + " " + extractedfile.getName() + "\n"
                  + getLocalizedDate( new Date(extractedfile.lastModified()) ) + ",  "
                  + extractedfile.length() + i18nmessages.getString("Bytes") + "\n"
                  + i18nmessages.getString("with_this_file_in_archive")
                  + getLocalizedDate(dateCompressedFile) + ",  "
                  + new Long(entry.getSize())
                  + i18nmessages.getString("Bytes"),
                i18nmessages.getString("Warning"), JOptionPane.DEFAULT_OPTION,
            JOptionPane.WARNING_MESSAGE, null, options,options[0]);

          if(overwrite == 2) //Don't overwrite
          {
            counterzipentries++;
            return;
          }
          else if( overwrite == 1) //Overwrite all files, won't prompt dialog again
          {
            alwaysoverwrite = true;
          }
      }
  
      //Creates a subdir if necessary
      File subdir = new File(extractedfile.getParent());
      if (subdir != null && !subdir.exists())
      {
        subdir.mkdirs();
      }
  
      writeStream = new FileOutputStream(extractedfile);
  
      while (true) 
      {
        nbBytesRead = readStream.read(buffer, 0, buffer.length);
        if (nbBytesRead == -1)
        	break;
        writeStream.write(buffer, 0, nbBytesRead);
      }

      writeStream.close();
      extractedfile.setLastModified(dateCompressedFile.getTime());
      counterzipentries++;
      nbextractedfiles++;
       if(counterzipentries==size)
         EndExtractProcess();
     }
    catch (Exception e)
    {
      System.out.println(e);
       if(writeStream!=null) { try {writeStream.close();} catch(IOException ioe) {} }
      if(readStream!=null) { try { readStream.close(); } catch(IOException ioe) {} }
    }
  }

  private void EndExtractProcess()
  {
    timer.cancel();
    progressbar.close();
    try {
    currentZipArchive.close();
    }catch(IOException ioe) {}

      
    JOptionPane.showMessageDialog
        (frameparentwindow, i18nmessages.getString("Successfully_extracted") + " " + nbextractedfiles + ((nbextractedfiles > 1) ? i18nmessages.getString("files"): i18nmessages.getString("file")) + "\n" +
        i18nmessages.getString("from") +  " " + zipfilename + "\n" + "into" + " " + extractdirectory.getPath(),
        i18nmessages.getString("KArchiver_SelfExtract_archive"),
         JOptionPane.INFORMATION_MESSAGE);
    System.exit(0);
  }
}
