/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>

#include "fulltext_pdf.h"
#include "kat_export.h"

extern "C"
{
    KAT_EXPORT FulltextExtractor* new_extractor( const QString& path ) {
        return new PDFExtractor( path );
    }
}

PDFExtractor::PDFExtractor( const QString &path ) :
    m_bDone( false ),
    m_path( path )
{
    kdDebug() << "PDFExtractor::PDFExtractor( const QString &path ) :************************" << endl;
}

PDFExtractor::~PDFExtractor()
{
    delete proc;
    proc = 0;
    delete kpm;
    kpm = 0;
}

void PDFExtractor::extract( QString& data )
{
    kdDebug() << "PDFExtractor start" << endl;
    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    proc = new KProcess();
    kpm = new KatProcessManager();

    QString helperApp = "pdftotext";

    *proc << helperApp;
    *proc << m_path;
    *proc << "-";
    *proc << "-enc";
    *proc << "UTF-8";

    QObject::connect( proc, SIGNAL( processExited( KProcess* ) ),
                      kpm, SLOT( slotProcessExited( KProcess* ) ) );
    QObject::connect( proc, SIGNAL( receivedStdout( KProcess*, char*, int ) ),
                      kpm, SLOT( slotReceivedStdout( KProcess*, char*, int ) ) );

    QString d = QString::null;

    if ( !proc->start( KProcess::Block, KProcess::Communication( KProcess::Stdout ) ) )
        kdDebug() << "ERROR: Unable to find helper program " << helperApp << endl;
    else
    {
        d = kpm->buffer();
        d = d.simplifyWhiteSpace();
    }

    QTextOStream stream( &data );
    stream << "<fulltext>";
    stream << d;
    stream << "</fulltext>";

    kdDebug() << "PDFExtractor end" << endl;
}

