/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qdom.h>
#include <kdialog.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qvariant.h>
#include <qsplitter.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qvbox.h>
#include <qpainter.h>
#include <kstdguiitem.h>

#include "dlgshowwordslist.h"
#include "dlgmainwindow.h"

class Word : public QListViewItem
{
public:

    Word( QListView* parent ) : QListViewItem( parent ) {};
    ~Word() {};

    int occurrences;

    int compare( QListViewItem*, int, bool ) const;
    void paintCell( QPainter*, const QColorGroup&, int, int, int );
};

int Word::compare( QListViewItem* other, int column, bool ascending ) const
{
    if ( column == 1 )
    {
        if ( occurrences < static_cast<Word*>(other)->occurrences )
            return -1;
        else if ( occurrences > static_cast<Word*>(other)->occurrences )
            return 1;
        else
            return 0;
    }
    else
    {
        return QListViewItem::compare( other, column, ascending );
    }
}

void Word::paintCell( QPainter* p, const QColorGroup& cg,
                           int column, int width, int align )
{
    // Do the standard painting
    QListViewItem::paintCell( p, cg, column, width, align );
    // Draw a box around the Cell
    p->setPen( cg.color( QColorGroup::Mid ) );
    p->drawLine( 0, height() - 1, width - 1, height() - 1 );
    p->lineTo( width - 1, 0 );
}

DlgShowWordsList::DlgShowWordsList( DlgMainWindow* mf, int fileId, const char* name, bool modal, WFlags fl )
   : KDialogBase( mf, name, modal, i18n( "List of Words" ), KDialogBase::User1|KDialogBase::Cancel),
     m_mf( mf )
{
    QVBox *page = makeVBoxMainWidget();

    lvWords = new QListView( page, "lvWords" );
    lvWords->setShowSortIndicator ( true );
    lvWords->setResizeMode( QListView::LastColumn );
    lvWords->addColumn( i18n( "Word" ) );
    lvWords->addColumn( i18n( "Occurrences" ) );
    lvWords->setColumnAlignment( 0, Qt::AlignLeft );
    lvWords->setColumnAlignment( 1, Qt::AlignRight );
    lvWords->header()->setLabel( 0, i18n( "Word" ) );
    lvWords->header()->setLabel( 1, i18n( "Occurrences" ) );

    resize( QSize( 360, 290 ).expandedTo( minimumSizeHint() ) );
    clearWState( WState_Polished );

    setButtonGuiItem( KDialogBase::User1, KStdGuiItem::saveAs() );

    // signals and slots connections
    connect( this, SIGNAL( user1Clicked() ), this, SLOT( slotSave() ) );
    init( fileId );
}

DlgShowWordsList::~DlgShowWordsList()
{
}

void DlgShowWordsList::init( int fileId )
{
    QMap<QString,int> words = m_mf->katEngine()->readFileWords( fileId );

    QMap<QString,int>::Iterator it;
    QMap<QString,int>::Iterator end( words.end() );
    for ( it = words.begin(); it != end; ++it )
    {
        Word *lvItem = new Word( lvWords );
        lvItem->occurrences = it.data();

        lvItem->setText( 0, it.key() );
        lvItem->setText( 1, QString::number( it.data() ) );
    }

}

void DlgShowWordsList::slotSave()
{
    QString fn = KFileDialog::getSaveFileName( QString::null, "*.txt|" + i18n( "Text Files (*.txt)" ), this ,
                                               i18n( "Specify Location & Filename for Text File" ) );
    if ( !fn.isEmpty() )
    {
        // save the xml file
        QDomDocument doc;
        // add the <?xml> line
        QDomProcessingInstruction instr = doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\" " );
        doc.appendChild( instr );

        // add the <!DOCTYPE> line
        QDomImplementation impl;
        QDomDocumentType type = impl.createDocumentType( "xml", 0, "xml.dtd" );
        doc.appendChild(type);

        QDomElement root = doc.createElement( "WORDS" );
        doc.appendChild( root );

        QListViewItemIterator it( lvWords );
        while ( it.current() )
        {
            QDomElement tag = doc.createElement( "WORD" );
            tag.setAttribute( "OCCURRENCES", it.current()->text( 1 ) );
            root.appendChild( tag );

            QDomText t = doc.createTextNode( it.current()->text( 0 ) );
            tag.appendChild( t );

            it++;
        }

        QFile file( fn );
        if( file.open( IO_WriteOnly ) )
        {
            QTextStream ts( &file );
            ts << doc.toString();

            file.close();
        }
        else
        {
            KMessageBox::information( this, i18n( "The file cannot be created in the specified location %1" ).arg( fn ) );
        }

    }
}

#include "dlgshowwordslist.moc"
