/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kiconview.h>
#include <kdebug.h>

#include "katiconview.h"
#include "katiconviewitem.h"

void KatIconView::dragEnterEvent( QDragEnterEvent* event )
{
    event->accept(
        QTextDrag::canDecode(event) ||
        QImageDrag::canDecode(event)
    );
}

void KatIconView::startDrag()
{
    QStrList files;
    QIconViewItem* item;

    for ( item = this->firstItem(); item; item = item->nextItem() )
    {
        if ( item->isSelected() )
        {
            KatIconViewItem* ivItem = static_cast<KatIconViewItem*>(item);
            files.append( ivItem->info.fullName );
        }
    }

    QDragObject* d = new QUriDrag( files, this );
    d->dragCopy();
    // do NOT delete d
}
