/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include "katiconviewitem.h"

#include <qiconview.h>

int KatIconViewItem::compare( QIconViewItem* other ) const
{
    QString key1, key2 = QString::null;

    if ( info.fileType == "inode/directory" )
        key1 = "0" + info.fileName;
    else
        key1 = "1" + info.fileName;

    if ( static_cast<KatIconViewItem*>(other)->info.fileType == "inode/directory" )
        key2 = "0" + static_cast<KatIconViewItem*>(other)->info.fileName;
    else
        key2 = "1" + static_cast<KatIconViewItem*>(other)->info.fileName;

    if ( key1 < key2 )
        return -1;
    else if ( key1 > key2 )
        return 1;
    else
        return 0;
}
