/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   salva_ste@tin.it                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "katalogdcop.h"

#include <katalog.h>
#include <kdebug.h>
#include <kapplication.h>

#include <dcopclient.h>

katalogdcop::katalogdcop() : QObject(), DCOPObject("katalogdcopInterface")
{
  runningJobs = 0;
}

katalogdcop::~katalogdcop()
{}

KatalogUDSEntryList katalogdcop::getNodeContent(KURL url, QString path)
{
  url.setProtocol("katalog");
  Katalog *k = katalog(url.path());
  if(!k){
    KatalogUDSEntryList list;
    list.clear();
    return list;
  }

  QStringList list = QStringList::split("/", path, false); 

  return k->getNodeContent(list);
}

int katalogdcop::initDocument(KURL url)
{
  if(!katalog(url.path()))
  {
    Katalog *k = new Katalog();
  
    int e = k->initDocument(url);
  
    if(e == Katalog::SUCCESS){
      m_map[url.path()] = k;
    }
    return e;
  }
  
  return 0;
}

void katalogdcop::saveDocuments()
{
  QMapIterator<QString, Katalog*> it;
  for ( it = m_map.begin(); it != m_map.end(); ++it ) {
    if((*it)->isChanged()){
      (*it)->saveDocument(it.key());
    }
  }
}

bool katalogdcop::saveDocument(KURL url, QString format)
{
  Katalog *k = katalog(url.path());
  
  if(!k)
    return false;

  if(format.isEmpty())
    return k->saveDocument(url);
  else
    return k->saveDocument(url, format.latin1());
}

/** Adds the items found in mount to the catalog, creating it if not exist */
int katalogdcop::addItems(KURL url, KURL mount,
                          QString catalog,
                          bool exploreArchives,
                          bool getMetaInfo)
{
  ++runningJobs;
  int e = initDocument(url);
  if(e != Katalog::SUCCESS)
    return e;
  
  Katalog *k = katalog(url.path());
  
  e = k->addItems(mount, catalog, exploreArchives, getMetaInfo);
  
  if(e == Katalog::SUCCESS){
    connect(k, SIGNAL(finished(QString)), this, SLOT(slotFinished(QString)));
  }
  return e;
}

/** Get the given entry */
KatalogUDSEntry katalogdcop::findEntry(KURL url, QString path)
{
  url.setProtocol("katalog");
  Katalog *k = katalog(url.path());
  if(!k){
    KatalogUDSEntry entry;
    entry.clear();
    return entry;
  }

  QStringList list = QStringList::split("/", path, false); 

  return k->findEntry(list);
}
 
/** Rename a node */
bool katalogdcop::rename(KURL url, QString path, QString newName)
{
  url.setProtocol("katalog");
  Katalog *k = katalog(url.path());
  if(!k)
    return false;
  
  QStringList list = QStringList::split("/", path, false); 
  
  bool e = k->rename(list, newName);
  
  if(e)
    k->saveDocument(url);
  
  return e;
}
  
/** Delete a node */
void katalogdcop::del(KURL url, QString path)
{
  Katalog *k = katalog(url.path());
  if(!k)
    return;

  QStringList list = QStringList::split("/", path, false); 

  k->del(list);
}

/** Returns the original URL of the stored file */
KURL katalogdcop::sourceURL(KURL url, QString path)
{
  Katalog *k = katalog(url.path());
  if(!k){
    KURL surl;
    return surl;
  }

  QStringList list = QStringList::split("/", path, false);

  return k->sourceURL(list);
}
  
QString katalogdcop::readInfo(KURL url, QString path)
{
  Katalog *k = katalog(url.path());
  if(!k)
  {
    // Return empty infos
    return "";
  }

  QStringList list = QStringList::split("/", path, false);
  
  return k->readInfo(list);
}

Katalog *katalogdcop::katalog(QString katalog)
{
  QMapIterator<QString, Katalog*> mit = m_map.find(katalog);
  if(mit == m_map.end())
    return 0L;
    
  return *mit;
}

QString katalogdcop::getDocumentsList()
{
  QString str;
  QMapIterator<QString, Katalog*> it;
  for ( it = m_map.begin(); it != m_map.end(); ++it ) {
    str.append( it.key() );
    str.append( "\n" );
  }
  return str;
}

void katalogdcop::slotFinished(QString url){
  --runningJobs;
  QByteArray params;
  QDataStream stream(params, IO_WriteOnly);
  stream << url;
  emitDCOPSignal("finished(QString)", params);
}

bool katalogdcop::exit()
{
  if(runningJobs==0)
  {
    kapp->quit();
    return true;
  }
  else
    return false;
}

#include "katalogdcop.moc"
