/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   salva_ste@tin.it                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _katalogdcop_H
#define _katalogdcop_H

#include <katalogdcopinterface.h>

#include <kataloguds.h>

#include <qstringlist.h>
#include <qstring.h>
#include <qmap.h>

#include <dcopobject.h>
#include <kurl.h>
#include <kio/job.h>
#include <kfilemetainfo.h>

class Katalog;

class katalogdcop : public QObject, virtual public katalogdcopInterface
{
Q_OBJECT

private:
  /** Map of open documents */
  QMap<QString, Katalog*> m_map;
  
  Katalog *katalog(QString katalog);
  
  int runningJobs;
  
public:
  katalogdcop();
  ~katalogdcop();

k_dcop:
  /** Get the list of contents in a node */
  virtual KatalogUDSEntryList getNodeContent(KURL katalog, QString fullPath);
  
  /** Init the document for further operations */
  virtual int initDocument(KURL url);
  
  /** Adds the items found in mount to the catalog, creating it if not exist */
  virtual int addItems(KURL url, KURL mount,
               QString catalog,
               bool exploreArchives=false,
               bool getMetaInfo=false);
 
  /** Save all documents to file */
  virtual void saveDocuments();
  
  /** Save the current document to file */
  virtual bool saveDocument(KURL katalog, QString format);

  /** Get the given entry */
  virtual KatalogUDSEntry findEntry(KURL katalog, QString fullPath);
  
  /** Rename a node */
  virtual bool rename(KURL katalog, QString path, QString newName);
  
  /** Delete a node */
  virtual void del(KURL katalog, QString path);
  
  /** Returns the original URL of the stored file */
  virtual KURL sourceURL(KURL katalog, QString path);

  /** Returns the Meta Info of the specified file */
  virtual QString readInfo(KURL katalog, QString path);
  
  /** Added for debug purposes */
  virtual QString getDocumentsList();
  
  /** Exits */    
  virtual bool exit();

k_dcop_signals:
  void finished(QString);
  
private slots:
  void slotFinished(QString);
};
#endif
