#ifndef _katalogslave_H_
#define _katalogslave_H_

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <unistd.h>

#include <qstring.h>
#include <qcstring.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>
#include <dcopclient.h>

class QCString;

class Katalog;

class kio_katalogProtocol : public KIO::SlaveBase, virtual public DCOPClient 
{
public:
  kio_katalogProtocol(const QCString &pool_socket, const QCString &app_socket);
  virtual ~kio_katalogProtocol();
  virtual void get(const KURL& url);
  virtual void stat(const KURL &);
  virtual void listDir(const KURL &);
  virtual void rename(const KURL &, const KURL &, bool);
  virtual void del(const KURL &, bool);

protected:
  bool checkNewFile( const KURL & url, QString & path );
  void wakeDCOP();

private:
  KURL * m_katalogURL;
  time_t m_mtime;
  QCString appId;
};

#endif
