/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano@diamante                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kapplication.h>
 
#include "katalogservicedlg.h"
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kurl.h>
#include <kaboutdata.h>
#include <dcopclient.h>

static const char description[] =
    I18N_NOOP("A simple catalog of your removable medias");

static const char version[] = "0.3";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("katalogservice", I18N_NOOP("Katalog Service Menu Dlg"), version, description,
                    KAboutData::License_GPL, "(C) 2004 Stefano Salvador", 0, 0, "salva_ste@tin.it");
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options );
  KApplication app;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  if (args->count() == 0)
    KCmdLineArgs::usage(i18n("No file specified!"));
  
  KURL *url = new KURL(args->arg(0));
  
  if (!url->isValid())
    KCmdLineArgs::usage(i18n("URL Not found!"));

  KatalogServiceDlg *dlg = new KatalogServiceDlg();
  dlg->setURL(url);
  dlg->show();
  app.setMainWidget( dlg );
  
  DCOPClient *client = app.dcopClient();
  client->attach();
  QCString appId = client->registerAs("katalogService");
  dlg->setClient(client);
  dlg->setAppID(appId);
  
  args->clear();
  
  return app.exec();
}
