AC_DEFUN(TEST_ASPELL,
[
AC_ARG_ENABLE(aspell,
AC_HELP_STRING([--enable-aspell], [Enable the aspell checker (default: no)]),
        aspell=$enableval, aspell=no)

AC_ARG_WITH(aspell,
AC_HELP_STRING([--with-aspell=PREFIX], [Prefix where aspell is installed (optional)]),
aspell_prefix="$withval", aspell_prefix="")

AC_ARG_WITH(aspell-libraries,
AC_HELP_STRING([--with-aspell-libraries=DIR], [Directory where aspell library is installed (optional)]),
aspell_libraries="$withval", aspell_libraries="")

AC_ARG_WITH(aspell-includes,
AC_HELP_STRING([--with-aspell-includes=DIR], [Directory where aspell header files are installed (optional)]),
aspell_includes="$withval", aspell_includes="")

  if test "x$aspell_libraries" != "x" ; then
    ASPELL_LIBS="-L$aspell_libraries"
  elif test "x$aspell_prefix" != "x"; then
    ASPELL_LIBS="-L$spell_prefix/lib"
  elif test "x$prefix" != "xNONE"; then
    ASPELL_LIBS="-L$prefix/lib"
  fi

  if test "x$aspell_includes" != "x" ; then
    ASPELL_CFLAGS="-I$aspell_includes"
  elif test "x$aspell_prefix" != "x"; then
    ASPELL_CFLAGS="-I$aspell_prefix/include"
  elif test "x$prefix" != "xNONE"; then 
    ASPELL_CFLAGS="-I$prefix/include"
  fi

if test "$aspell" = "yes"; then
  aaspell_l=no
  AC_CHECK_HEADER(aspell.h, aspell_h=yes, aspell_h=no)
  if test "$aspell_h" = "yes"; then
   AC_CHECK_LIB(aspell, new_aspell_speller, aspell_l=yes,aspell_l=no)
  fi

 if test "$aspell_l" = "yes"; then
  AC_DEFINE(HAVE_SPELL,,[Enable the spell checker])
  ASPELL_LIBS="$ASPELL_LIBS -laspell"
  else
    AC_MSG_WARN([I couldn't find aspell, The spell checker will be disabled ])
   aspell=no
  fi
 fi
])
