/*
 * pdf.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "pipe.hh"
#include "pdf.hh"
#include "utils.hh"
#include <glib.h>

PDF::PDF() {

}

PDF::~PDF() {

}

bool PDF::process(std::string& file, std::string& er) {
  std::string command("gs -sDEVICE=pdfwrite -dNOPAUSE -dBATCH -q -sOutputFile=- " + file);
  std::string out;

  if (!Pipe::exec("gs", command, out, er)) {
    return false;
  }

  return write(out, er);
}

bool PDF::get_page(int pg, std::string& out, std::string& err) {
  // TODO: Is there a clean way to make our class aware of this ?
  /*  assert(pg <= pages); */
  return Pipe::exec("gs", Utils::substitute("gs -dNOPAUSE -dBATCH -q -sDEVICE=png256 -sOutputFile=- -dFirstPage=%i -dLastPage=%i %s", pg, pg, get_name()), out, err);
}
