/***************************************************************************
 *   Copyright (C) 2004 by Paul Giannaros                                  *
 *   ceruleanblaze@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kwin.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <kdebug.h>
#include <kpushbutton.h>

#include <qtimer.h>

#include "kautoclick.h"
#include "kautoclickwidget.h"

#include <X11/extensions/XTest.h>

KAutoClick::KAutoClick() : KMainWindow(0, "KAutoClick") {
    QPixmap winIcon("hi32-app-kautoclick.png");
    KWin::setIcons(this->winId(), winIcon, winIcon);
    m_widget = new KAutoClickWidget(this);
    stop = false;
    
    /// Disable the stop button by default.
    m_widget->m_stopButton->setEnabled(false);
    setCentralWidget(m_widget);
    
    /// On a screenClickRequest, send a click to the screen... smart huh.
    connect(m_widget, SIGNAL(screenClickRequest(int)), this, SLOT(sendClick(int)));
    connect(m_widget, SIGNAL(stopClickRequest()), this, SLOT(stopClick()));
}

KAutoClick::~KAutoClick() {
    ;
}

/***** Slots **/
void KAutoClick::stopClick() {
    m_widget->m_startButton->setEnabled(true);
    m_widget->m_stopButton->setEnabled(false);
    stop = true;
}

/**
 * A small wrapper around void XClick(). Just sets 
 * m_interval to parameter (int) and then calls XClick.
 * @PARAM (int)           milliseconds between each click.
 */
void KAutoClick::sendClick(int i) {
    m_interval = i;
    /// Enable and disable accordingly.
    m_widget->m_startButton->setEnabled(false);
    m_widget->m_stopButton->setEnabled(true);
    XClick();
}
void KAutoClick::XClick() {
    /// Send a click event to the X server if stop has not been clicked.
    if(!stop) {
	kdDebug() << "Click" << endl;
	XTestFakeButtonEvent(this->x11Display(), 1, true, CurrentTime);
	XTestFakeButtonEvent(this->x11Display(), 1, false, CurrentTime);
	/// If stop is false then repeat after m_interval milliseconds.
	QTimer::singleShot(m_interval, this, SLOT(XClick()));
    }
    stop = false;
}


#include "kautoclick.moc"
