/***************************************************************************
 *   Copyright (C) 2004 by Paul Giannaros                                  *
 *   ceruleanblaze@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KAUTOCLICK_H_
#define _KAUTOCLICK_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

class KAutoClickWidget;

/**
 * @short An auto clicker for KDE.
 * @author Paul Giannaros <ceruleanblaze@gmail.com>
 * @version 0.1
 */
class KAutoClick : public KMainWindow {
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KAutoClick();
    /**
     * Default Destructor
     */
    virtual ~KAutoClick();

public slots:
    /**
     * A small wrapper around void XClick(). Just sets 
     * m_interval to parameter (int) and then calls XClick.
     * @PARAM (int)           milliseconds between each click.
     */
    void sendClick(int);

    /**
      * Sends a click event to the X11 server using the Xtest lib. If 
      * stop != true then it uses a QTimer to call itself in m_interval
      * seconds.
      */
    void XClick();
    
    /// Stops the clicking by setting stop to false.
    void stopClick();

private:
    /// Pretty GUI... not really.
    KAutoClickWidget *m_widget;
    /// Interval between clicks. 
    int m_interval;
    /// Tell us when clicking should stop.
    volatile bool stop;
};

#endif // _KAUTOCLICK_H_
