//
// C++ Interface: entrezsearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ENTREZSEARCHER_H
#define ENTREZSEARCHER_H

#include "searcher.h"
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/

class EntrezSearcher;

class EntrezConfigWidget : public SearcherConfigWidget {
	public:
		EntrezConfigWidget(QWidget* parent, EntrezSearcher* searcher = 0);
		virtual void updateSearcher() {};


};

class EntrezSearcher : public searcher
{
Q_OBJECT
	public:
		EntrezSearcher(QObject* parent, const char* name=0);
  /**
   */
		virtual ~EntrezSearcher();

		virtual QString source() const;
		virtual void setSource(const QString );
		virtual bool isSearching() const { return m_started; }
		virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
		virtual void stop();
		virtual Type type() const { return Entrez; }
		virtual void readConfig(KConfig* config, const QString& group);
		virtual void saveConfig(KConfig* config);
		virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
		friend class EntrezConfigWidget;
		virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
		virtual void retrieveRange(unsigned int min, unsigned int max);
		virtual QStringList searchKey();
		virtual int maxSearchTerms() {return 100; }
		static QString defaultName();

	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);

	private:
		void searchResults();
		void fetchResults();

		enum Step {
			Begin,
			Search,
			Wait,
			Fetch
		};

		KURL m_url;
		QString m_dbname;
		QByteArray m_data;
		int m_total;
		QString m_queryKey;
		QString m_webEnv;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;
};



#endif
